///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995/2004 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor : Xilinx
// \   \   \/     Version : 10.1
//  \   \         Description : Xilinx Functional Simulation Library Component
//  /   /                  11-Gigabit Transceiver for High-Speed I/O Simulation Model
// /___/   /\     Filename : GT11.v
// \   \  /  \    Timestamp : Fri Jun 18 10:57:01 PDT 2004
//  \___\/\___\
//
// Revision:
//    03/23/04 - Initial version.
//    05/16/05 - Changed default values for some parameters and removed two parameters. Fixed CR#207101.
//    08/08/05 - Changed default parameter values for some parameters (CR 214282).
//    02/22/06 - CR#226003 - Added integer, real parameter type
//    02/28/06 - CR#226322 - Addition of new parameters and change of default values for some parameters.
// End Revision

`timescale 1 ps / 1 ps 

module GT11 (
	CHBONDO,
	COMBUSOUT,
	DO,
	DRDY,
	RXBUFERR,
	RXCALFAIL,
	RXCHARISCOMMA,
	RXCHARISK,
	RXCOMMADET,
	RXCRCOUT,
	RXCYCLELIMIT,
	RXDATA,
	RXDISPERR,
	RXLOCK,
	RXLOSSOFSYNC,
	RXMCLK,
	RXNOTINTABLE,
	RXPCSHCLKOUT,
	RXREALIGN,
	RXRECCLK1,
	RXRECCLK2,
	RXRUNDISP,
	RXSIGDET,
	RXSTATUS,
	TX1N,
	TX1P,
	TXBUFERR,
	TXCALFAIL,
	TXCRCOUT,
	TXCYCLELIMIT,
	TXKERR,
	TXLOCK,
	TXOUTCLK1,
	TXOUTCLK2,
	TXPCSHCLKOUT,
	TXRUNDISP,
	CHBONDI,
	COMBUSIN,
	DADDR,
	DCLK,
	DEN,
	DI,
	DWE,
	ENCHANSYNC,
	ENMCOMMAALIGN,
	ENPCOMMAALIGN,
	GREFCLK,
	LOOPBACK,
	POWERDOWN,
	REFCLK1,
	REFCLK2,
	RX1N,
	RX1P,
	RXBLOCKSYNC64B66BUSE,
	RXCLKSTABLE,
	RXCOMMADETUSE,
	RXCRCCLK,
	RXCRCDATAVALID,
	RXCRCDATAWIDTH,
	RXCRCIN,
	RXCRCINIT,
	RXCRCINTCLK,
	RXCRCPD,
	RXCRCRESET,
	RXDATAWIDTH,
	RXDEC64B66BUSE,
	RXDEC8B10BUSE,
	RXDESCRAM64B66BUSE,
	RXIGNOREBTF,
	RXINTDATAWIDTH,
	RXPMARESET,
	RXPOLARITY,
	RXRESET,
	RXSLIDE,
	RXSYNC,
	RXUSRCLK,
	RXUSRCLK2,
	TXBYPASS8B10B,
	TXCHARDISPMODE,
	TXCHARDISPVAL,
	TXCHARISK,
	TXCLKSTABLE,
	TXCRCCLK,
	TXCRCDATAVALID,
	TXCRCDATAWIDTH,
	TXCRCIN,
	TXCRCINIT,
	TXCRCINTCLK,
	TXCRCPD,
	TXCRCRESET,
	TXDATA,
	TXDATAWIDTH,
	TXENC64B66BUSE,
	TXENC8B10BUSE,
	TXENOOB,
	TXGEARBOX64B66BUSE,
	TXINHIBIT,
	TXINTDATAWIDTH,
	TXPMARESET,
	TXPOLARITY,
	TXRESET,
	TXSCRAM64B66BUSE,
	TXSYNC,
	TXUSRCLK,
	TXUSRCLK2
);

parameter BANDGAPSEL = "FALSE";
parameter BIASRESSEL = "FALSE";
parameter CCCB_ARBITRATOR_DISABLE = "FALSE";
parameter CHAN_BOND_MODE = "NONE";
parameter CHAN_BOND_ONE_SHOT = "FALSE";
parameter CHAN_BOND_SEQ_1_1 = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_2 = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_3 = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_4 = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_MASK = 4'b1110;
parameter CHAN_BOND_SEQ_2_1 = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_2 = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_3 = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_4 = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_MASK = 4'b1110;
parameter CHAN_BOND_SEQ_2_USE = "FALSE";
parameter CLK_CORRECT_USE = "FALSE";
parameter CLK_COR_8B10B_DE = "FALSE";
parameter CLK_COR_SEQ_1_1 = 11'b00000000000;
parameter CLK_COR_SEQ_1_2 = 11'b00000000000;
parameter CLK_COR_SEQ_1_3 = 11'b00000000000;
parameter CLK_COR_SEQ_1_4 = 11'b00000000000;
parameter CLK_COR_SEQ_1_MASK = 4'b1110;
parameter CLK_COR_SEQ_2_1 = 11'b00000000000;
parameter CLK_COR_SEQ_2_2 = 11'b00000000000;
parameter CLK_COR_SEQ_2_3 = 11'b00000000000;
parameter CLK_COR_SEQ_2_4 = 11'b00000000000;
parameter CLK_COR_SEQ_2_MASK = 4'b1110;
parameter CLK_COR_SEQ_2_USE = "FALSE";
parameter CLK_COR_SEQ_DROP = "FALSE";
parameter COMMA32 = "FALSE";
parameter COMMA_10B_MASK = 10'h3FF;
parameter CYCLE_LIMIT_SEL = 2'b00;
parameter DCDR_FILTER = 3'b010;
parameter DEC_MCOMMA_DETECT = "TRUE";
parameter DEC_PCOMMA_DETECT = "TRUE";
parameter DEC_VALID_COMMA_ONLY = "TRUE";
parameter DIGRX_FWDCLK = 2'b00;
parameter DIGRX_SYNC_MODE = "FALSE";
parameter ENABLE_DCDR = "FALSE";
parameter FDET_HYS_CAL = 3'b010;
parameter FDET_HYS_SEL = 3'b100;
parameter FDET_LCK_CAL = 3'b100;
parameter FDET_LCK_SEL = 3'b001;
parameter GT11_MODE = "DONT_CARE";
parameter IREFBIASMODE = 2'b11;
parameter LOOPCAL_WAIT = 2'b00;
parameter MCOMMA_32B_VALUE = 32'h00000000;
parameter MCOMMA_DETECT = "TRUE";
parameter OPPOSITE_SELECT = "FALSE";
parameter PCOMMA_32B_VALUE = 32'h00000000;
parameter PCOMMA_DETECT = "TRUE";
parameter PCS_BIT_SLIP = "FALSE";
parameter PMACLKENABLE = "TRUE";
parameter PMACOREPWRENABLE = "TRUE";
parameter PMAIREFTRIM = 4'b0111;
parameter PMAVBGCTRL = 5'b00000;
parameter PMAVREFTRIM = 4'b0111;
parameter PMA_BIT_SLIP = "FALSE";
parameter POWER_ENABLE = "TRUE";
parameter REPEATER = "FALSE";
parameter RXACTST = "FALSE";
parameter RXAFEEQ = 9'b000000000;
parameter RXAFEPD = "FALSE";
parameter RXAFETST = "FALSE";
parameter RXAPD = "FALSE";
parameter RXAREGCTRL = 5'b00000;
parameter RXASYNCDIVIDE = 2'b11;
parameter RXBY_32 = "FALSE";
parameter RXCDRLOS = 6'b000000;
parameter RXCLK0_FORCE_PMACLK = "FALSE";
parameter RXCLKMODE = 6'b110001;
parameter RXCLMODE = 2'b00;
parameter RXCMADJ = 2'b01;
parameter RXCPSEL = "TRUE";
parameter RXCPTST = "FALSE";
parameter RXCRCCLOCKDOUBLE = "FALSE";
parameter RXCRCENABLE = "FALSE";
parameter RXCRCINITVAL = 32'h00000000;
parameter RXCRCINVERTGEN = "FALSE";
parameter RXCRCSAMECLOCK = "FALSE";
parameter RXCTRL1 = 10'h200;
parameter RXCYCLE_LIMIT_SEL = 2'b00;
parameter RXDATA_SEL = 2'b00;
parameter RXDCCOUPLE = "FALSE";
parameter RXDIGRESET = "FALSE";
parameter RXDIGRX = "FALSE";
parameter RXEQ = 64'h4000000000000000;
parameter RXFDCAL_CLOCK_DIVIDE = "NONE";
parameter RXFDET_HYS_CAL = 3'b010;
parameter RXFDET_HYS_SEL = 3'b100;
parameter RXFDET_LCK_CAL = 3'b100;
parameter RXFDET_LCK_SEL = 3'b001;
parameter RXFECONTROL1 = 2'b00;
parameter RXFECONTROL2 = 3'b000;
parameter RXFETUNE = 2'b01;
parameter RXLB = "FALSE";
parameter RXLKADJ = 5'b00000;
parameter RXLKAPD = "FALSE";
parameter RXLOOPCAL_WAIT = 2'b00;
parameter RXLOOPFILT = 4'b0111;
parameter RXMODE = 6'b000000;
parameter RXPD = "FALSE";
parameter RXPDDTST = "TRUE";
parameter RXPMACLKSEL = "REFCLK1";
parameter RXRCPADJ = 3'b011;
parameter RXRCPPD = "FALSE";
parameter RXRECCLK1_USE_SYNC = "FALSE";
parameter RXRIBADJ = 2'b11;
parameter RXRPDPD = "FALSE";
parameter RXRSDPD = "FALSE";
parameter RXSLOWDOWN_CAL = 2'b00;
parameter RXTUNE = 13'h0000;
parameter RXVCODAC_INIT = 10'b1010000000;
parameter RXVCO_CTRL_ENABLE = "FALSE";
parameter RX_BUFFER_USE = "TRUE";
parameter RX_CLOCK_DIVIDER = 2'b00;
parameter SAMPLE_8X = "FALSE";
parameter SLOWDOWN_CAL = 2'b00;
parameter TXABPMACLKSEL = "REFCLK1";
parameter TXAPD = "FALSE";
parameter TXAREFBIASSEL = "TRUE";
parameter TXASYNCDIVIDE = 2'b11;
parameter TXCLK0_FORCE_PMACLK = "FALSE";
parameter TXCLKMODE = 4'b1001;
parameter TXCLMODE = 2'b00;
parameter TXCPSEL = "TRUE";
parameter TXCRCCLOCKDOUBLE = "FALSE";
parameter TXCRCENABLE = "FALSE";
parameter TXCRCINITVAL = 32'h00000000;
parameter TXCRCINVERTGEN = "FALSE";
parameter TXCRCSAMECLOCK = "FALSE";
parameter TXCTRL1 = 10'h200;
parameter TXDATA_SEL = 2'b00;
parameter TXDAT_PRDRV_DAC = 3'b111;
parameter TXDAT_TAP_DAC = 5'b10110;
parameter TXDIGPD = "FALSE";
parameter TXFDCAL_CLOCK_DIVIDE = "NONE";
parameter TXHIGHSIGNALEN = "TRUE";
parameter TXLOOPFILT = 4'b0111;
parameter TXLVLSHFTPD = "FALSE";
parameter TXOUTCLK1_USE_SYNC = "FALSE";
parameter TXPD = "FALSE";
parameter TXPHASESEL = "FALSE";
parameter TXPOST_PRDRV_DAC = 3'b111;
parameter TXPOST_TAP_DAC = 5'b01110;
parameter TXPOST_TAP_PD = "TRUE";
parameter TXPRE_PRDRV_DAC = 3'b111;
parameter TXPRE_TAP_DAC = 5'b00000;
parameter TXPRE_TAP_PD = "TRUE";
parameter TXSLEWRATE = "FALSE";
parameter TXTERMTRIM = 4'b1100;
parameter TXTUNE = 13'h0000;
parameter TX_BUFFER_USE = "TRUE";
parameter TX_CLOCK_DIVIDER = 2'b00;
parameter VCODAC_INIT = 10'b1010000000;
parameter VCO_CTRL_ENABLE = "FALSE";
parameter VREFBIASMODE = 2'b11;
parameter integer ALIGN_COMMA_WORD = 4;
parameter integer CHAN_BOND_LIMIT = 16;
parameter integer CHAN_BOND_SEQ_LEN = 1;
parameter integer CLK_COR_MAX_LAT = 48;
parameter integer CLK_COR_MIN_LAT = 36;
parameter integer CLK_COR_SEQ_LEN = 1;
parameter integer RXOUTDIV2SEL = 1;
parameter integer RXPLLNDIVSEL = 8;
parameter integer RXUSRDIVISOR = 1;
parameter integer SH_CNT_MAX = 64;
parameter integer SH_INVALID_CNT_MAX = 16;
parameter integer TXOUTDIV2SEL = 1;
parameter integer TXPLLNDIVSEL = 8;


output DRDY;
output RXBUFERR;
output RXCALFAIL;
output RXCOMMADET;
output RXCYCLELIMIT;
output RXLOCK;
output RXMCLK;
output RXPCSHCLKOUT;
output RXREALIGN;
output RXRECCLK1;
output RXRECCLK2;
output RXSIGDET;
output TX1N;
output TX1P;
output TXBUFERR;
output TXCALFAIL;
output TXCYCLELIMIT;
output TXLOCK;
output TXOUTCLK1;
output TXOUTCLK2;
output TXPCSHCLKOUT;
output [15:0] COMBUSOUT;
output [15:0] DO;
output [1:0] RXLOSSOFSYNC;
output [31:0] RXCRCOUT;
output [31:0] TXCRCOUT;
output [4:0] CHBONDO;
output [5:0] RXSTATUS;
output [63:0] RXDATA;
output [7:0] RXCHARISCOMMA;
output [7:0] RXCHARISK;
output [7:0] RXDISPERR;
output [7:0] RXNOTINTABLE;
output [7:0] RXRUNDISP;
output [7:0] TXKERR;
output [7:0] TXRUNDISP;

input DCLK;
input DEN;
input DWE;
input ENCHANSYNC;
input ENMCOMMAALIGN;
input ENPCOMMAALIGN;
input GREFCLK;
input POWERDOWN;
input REFCLK1;
input REFCLK2;
input RX1N;
input RX1P;
input RXBLOCKSYNC64B66BUSE;
input RXCLKSTABLE;
input RXCOMMADETUSE;
input RXCRCCLK;
input RXCRCDATAVALID;
input RXCRCINIT;
input RXCRCINTCLK;
input RXCRCPD;
input RXCRCRESET;
input RXDEC64B66BUSE;
input RXDEC8B10BUSE;
input RXDESCRAM64B66BUSE;
input RXIGNOREBTF;
input RXPMARESET;
input RXPOLARITY;
input RXRESET;
input RXSLIDE;
input RXSYNC;
input RXUSRCLK2;
input RXUSRCLK;
input TXCLKSTABLE;
input TXCRCCLK;
input TXCRCDATAVALID;
input TXCRCINIT;
input TXCRCINTCLK;
input TXCRCPD;
input TXCRCRESET;
input TXENC64B66BUSE;
input TXENC8B10BUSE;
input TXENOOB;
input TXGEARBOX64B66BUSE;
input TXINHIBIT;
input TXPMARESET;
input TXPOLARITY;
input TXRESET;
input TXSCRAM64B66BUSE;
input TXSYNC;
input TXUSRCLK2;
input TXUSRCLK;
input [15:0] COMBUSIN;
input [15:0] DI;
input [1:0] LOOPBACK;
input [1:0] RXDATAWIDTH;
input [1:0] RXINTDATAWIDTH;
input [1:0] TXDATAWIDTH;
input [1:0] TXINTDATAWIDTH;
input [2:0] RXCRCDATAWIDTH;
input [2:0] TXCRCDATAWIDTH;
input [4:0] CHBONDI;
input [63:0] RXCRCIN;
input [63:0] TXCRCIN;
input [63:0] TXDATA;
input [7:0] DADDR;
input [7:0] TXBYPASS8B10B;
input [7:0] TXCHARDISPMODE;
input [7:0] TXCHARDISPVAL;
input [7:0] TXCHARISK;

reg BANDGAPSEL_BINARY;
reg BIASRESSEL_BINARY;
reg CCCB_ARBITRATOR_DISABLE_BINARY;
reg CHAN_BOND_ONE_SHOT_BINARY;
reg CHAN_BOND_SEQ_2_USE_BINARY;
reg CLK_CORRECT_USE_BINARY;
reg CLK_COR_8B10B_DE_BINARY;
reg CLK_COR_SEQ_2_USE_BINARY;
reg CLK_COR_SEQ_DROP_BINARY;
reg COMMA32_BINARY;
reg DEC_MCOMMA_DETECT_BINARY;
reg DEC_PCOMMA_DETECT_BINARY;
reg DEC_VALID_COMMA_ONLY_BINARY;
reg DIGRX_SYNC_MODE_BINARY;
reg ENABLE_DCDR_BINARY;
reg MCOMMA_DETECT_BINARY;
reg OPPOSITE_SELECT_BINARY;
reg PCOMMA_DETECT_BINARY;
reg PCS_BIT_SLIP_BINARY;
reg PMACLKENABLE_BINARY;
reg PMACOREPWRENABLE_BINARY;
reg PMA_BIT_SLIP_BINARY;
reg POWER_ENABLE_BINARY;
reg REPEATER_BINARY;
reg RXACTST_BINARY;
reg RXAFEPD_BINARY;
reg RXAFETST_BINARY;
reg RXAPD_BINARY;
reg RXBY_32_BINARY;
reg RXCLK0_FORCE_PMACLK_BINARY;
reg RXCPSEL_BINARY;
reg RXCPTST_BINARY;
reg RXCRCCLOCKDOUBLE_BINARY;
reg RXCRCENABLE_BINARY;
reg RXCRCINVERTGEN_BINARY;
reg RXCRCSAMECLOCK_BINARY;
reg RXDCCOUPLE_BINARY;
reg RXDIGRESET_BINARY;
reg RXDIGRX_BINARY;
reg RXLB_BINARY;
reg RXLKAPD_BINARY;
reg RXPDDTST_BINARY;
reg RXPD_BINARY;
reg RXRCPPD_BINARY;
reg RXRECCLK1_USE_SYNC_BINARY;
reg RXRPDPD_BINARY;
reg RXRSDPD_BINARY;
reg RXVCO_CTRL_ENABLE_BINARY;
reg RX_BUFFER_USE_BINARY;
reg SAMPLE_8X_BINARY;
reg TXAPD_BINARY;
reg TXAREFBIASSEL_BINARY;
reg TXCLK0_FORCE_PMACLK_BINARY;
reg TXCPSEL_BINARY;
reg TXCRCCLOCKDOUBLE_BINARY;
reg TXCRCENABLE_BINARY;
reg TXCRCINVERTGEN_BINARY;
reg TXCRCSAMECLOCK_BINARY;
reg TXDIGPD_BINARY;
reg TXHIGHSIGNALEN_BINARY;
reg TXLVLSHFTPD_BINARY;
reg TXOUTCLK1_USE_SYNC_BINARY;
reg TXPD_BINARY;
reg TXPHASESEL_BINARY;
reg TXPOST_TAP_PD_BINARY;
reg TXPRE_TAP_PD_BINARY;
reg TXSLEWRATE_BINARY;
reg TX_BUFFER_USE_BINARY;
reg VCO_CTRL_ENABLE_BINARY;
reg [1:0] GT11_MODE_BINARY;
reg [12:0] RXTUNE_BINARY;
reg [12:0] TXTUNE_BINARY;
reg [1:0] ALIGN_COMMA_WORD_BINARY;
reg [1:0] CHAN_BOND_MODE_BINARY;
reg [1:0] RXFDCAL_CLOCK_DIVIDE_BINARY;
reg [1:0] RXPMACLKSEL_BINARY;
reg [1:0] TXABPMACLKSEL_BINARY;
reg [1:0] TXFDCAL_CLOCK_DIVIDE_BINARY;
reg [2:0] CHAN_BOND_SEQ_LEN_BINARY;
reg [2:0] CLK_COR_SEQ_LEN_BINARY;
reg [31:0] MCOMMA_32B_VALUE_BINARY;
reg [31:0] PCOMMA_32B_VALUE_BINARY;
reg [31:0] RXCRCINITVAL_BINARY;
reg [31:0] TXCRCINITVAL_BINARY;
reg [3:0] RXPLLNDIVSEL_BINARY;
reg [3:0] TXOUTDIV2SEL_BINARY;
reg [3:0] TXPLLNDIVSEL_BINARY;
reg [4:0] RXUSRDIVISOR_BINARY;
reg [5:0] CHAN_BOND_LIMIT_BINARY;
reg [5:0] CLK_COR_MAX_LAT_BINARY;
reg [5:0] CLK_COR_MIN_LAT_BINARY;
reg [63:0] RXEQ_BINARY;
reg [7:0] RXOUTDIV2SEL_BINARY;
reg [7:0] SH_CNT_MAX_BINARY;
reg [7:0] SH_INVALID_CNT_MAX_BINARY;
reg [9:0] COMMA_10B_MASK_BINARY;
reg [9:0] RXCTRL1_BINARY;
reg [9:0] TXCTRL1_BINARY;

tri0 GSR = glbl.GSR;

reg notifier;

wire DCLK_IN;
wire DEN_IN;
wire DRDY_OUT;
wire DWE_IN;
wire ENCHANSYNC_IN;
wire ENMCOMMAALIGN_IN;
wire ENPCOMMAALIGN_IN;
wire GREFCLK_IN;
wire POWERDOWN_IN;
wire REFCLK1_IN;
wire REFCLK2_IN;
wire RX1N_IN;
wire RX1P_IN;
wire RXBLOCKSYNC64B66BUSE_IN;
wire RXBUFERR_OUT;
wire RXCALFAIL_OUT;
wire RXCLKSTABLE_IN;
wire RXCOMMADETUSE_IN;
wire RXCOMMADET_OUT;
wire RXCRCCLK_IN;
wire RXCRCDATAVALID_IN;
wire RXCRCINIT_IN;
wire RXCRCINTCLK_IN;
wire RXCRCPD_IN;
wire RXCRCRESET_IN;
wire RXCYCLELIMIT_OUT;
wire RXDEC64B66BUSE_IN;
wire RXDEC8B10BUSE_IN;
wire RXDESCRAM64B66BUSE_IN;
wire RXIGNOREBTF_IN;
wire RXLOCK_OUT;
wire RXMCLK_OUT;
wire RXPCSHCLKOUT_OUT;
wire RXPMARESET_IN;
wire RXPOLARITY_IN;
wire RXREALIGN_OUT;
wire RXRECCLK1_OUT;
wire RXRECCLK2_OUT;
wire RXRESET_IN;
wire RXSIGDET_OUT;
wire RXSLIDE_IN;
wire RXSYNC_IN;
wire RXUSRCLK2_IN;
wire RXUSRCLK_IN;
wire TX1N_OUT;
wire TX1P_OUT;
wire TXBUFERR_OUT;
wire TXCALFAIL_OUT;
wire TXCLKSTABLE_IN;
wire TXCRCCLK_IN;
wire TXCRCDATAVALID_IN;
wire TXCRCINIT_IN;
wire TXCRCINTCLK_IN;
wire TXCRCPD_IN;
wire TXCRCRESET_IN;
wire TXCYCLELIMIT_OUT;
wire TXENC64B66BUSE_IN;
wire TXENC8B10BUSE_IN;
wire TXENOOB_IN;
wire TXGEARBOX64B66BUSE_IN;
wire TXINHIBIT_IN;
wire TXLOCK_OUT;
wire TXOUTCLK1_OUT;
wire TXOUTCLK2_OUT;
wire TXPCSHCLKOUT_OUT;
wire TXPMARESET_IN;
wire TXPOLARITY_IN;
wire TXRESET_IN;
wire TXSCRAM64B66BUSE_IN;
wire TXSYNC_IN;
wire TXUSRCLK2_IN;
wire TXUSRCLK_IN;
wire [15:0] COMBUSIN_IN;
wire [15:0] COMBUSOUT_OUT;
wire [15:0] DI_IN;
wire [15:0] DO_OUT;
wire [1:0] LOOPBACK_IN;
wire [1:0] RXDATAWIDTH_IN;
wire [1:0] RXINTDATAWIDTH_IN;
wire [1:0] RXLOSSOFSYNC_OUT;
wire [1:0] TXDATAWIDTH_IN;
wire [1:0] TXINTDATAWIDTH_IN;
wire [2:0] RXCRCDATAWIDTH_IN;
wire [2:0] TXCRCDATAWIDTH_IN;
wire [31:0] RXCRCOUT_OUT;
wire [31:0] TXCRCOUT_OUT;
wire [4:0] CHBONDI_IN;
wire [4:0] CHBONDO_OUT;
wire [5:0] RXSTATUS_OUT;
wire [63:0] RXCRCIN_IN;
wire [63:0] RXDATA_OUT;
wire [63:0] TXCRCIN_IN;
wire [63:0] TXDATA_IN;
wire [7:0] DADDR_IN;
wire [7:0] RXCHARISCOMMA_OUT;
wire [7:0] RXCHARISK_OUT;
wire [7:0] RXDISPERR_OUT;
wire [7:0] RXNOTINTABLE_OUT;
wire [7:0] RXRUNDISP_OUT;
wire [7:0] TXBYPASS8B10B_IN;
wire [7:0] TXCHARDISPMODE_IN;
wire [7:0] TXCHARDISPVAL_IN;
wire [7:0] TXCHARISK_IN;
wire [7:0] TXKERR_OUT;
wire [7:0] TXRUNDISP_OUT;

initial begin
	case (GT11_MODE)
		"B" : GT11_MODE_BINARY <= 2'b00;
		"A" : GT11_MODE_BINARY <= 2'b01;
		"DONT_CARE" : GT11_MODE_BINARY <= 2'b10;
		"SINGLE" : GT11_MODE_BINARY <= 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute GT11_MODE on GT11 instance %m is set to %s.  Legal values for this attribute are DONT_CARE, A, B or SINGLE.", GT11_MODE);
			$finish;
		end
	endcase

	case (CHAN_BOND_LIMIT)
		0 : CHAN_BOND_LIMIT_BINARY <= 6'b000000;
		1 : CHAN_BOND_LIMIT_BINARY <= 6'b000001;
		2 : CHAN_BOND_LIMIT_BINARY <= 6'b000010;
		3 : CHAN_BOND_LIMIT_BINARY <= 6'b000011;
		4 : CHAN_BOND_LIMIT_BINARY <= 6'b000100;
		5 : CHAN_BOND_LIMIT_BINARY <= 6'b000101;
		6 : CHAN_BOND_LIMIT_BINARY <= 6'b000110;
		7 : CHAN_BOND_LIMIT_BINARY <= 6'b000111;
		8 : CHAN_BOND_LIMIT_BINARY <= 6'b001000;
		9 : CHAN_BOND_LIMIT_BINARY <= 6'b001001;
		10 : CHAN_BOND_LIMIT_BINARY <= 6'b001010;
		11 : CHAN_BOND_LIMIT_BINARY <= 6'b001011;
		12 : CHAN_BOND_LIMIT_BINARY <= 6'b001100;
		13 : CHAN_BOND_LIMIT_BINARY <= 6'b001101;
		14 : CHAN_BOND_LIMIT_BINARY <= 6'b001110;
		15 : CHAN_BOND_LIMIT_BINARY <= 6'b001111;
		16 : CHAN_BOND_LIMIT_BINARY <= 6'b010000;
		17 : CHAN_BOND_LIMIT_BINARY <= 6'b010001;
		18 : CHAN_BOND_LIMIT_BINARY <= 6'b010010;
		19 : CHAN_BOND_LIMIT_BINARY <= 6'b010011;
		20 : CHAN_BOND_LIMIT_BINARY <= 6'b010100;
		21 : CHAN_BOND_LIMIT_BINARY <= 6'b010101;
		22 : CHAN_BOND_LIMIT_BINARY <= 6'b010110;
		23 : CHAN_BOND_LIMIT_BINARY <= 6'b010111;
		24 : CHAN_BOND_LIMIT_BINARY <= 6'b011000;
		25 : CHAN_BOND_LIMIT_BINARY <= 6'b011001;
		26 : CHAN_BOND_LIMIT_BINARY <= 6'b011010;
		27 : CHAN_BOND_LIMIT_BINARY <= 6'b011011;
		28 : CHAN_BOND_LIMIT_BINARY <= 6'b011100;
		29 : CHAN_BOND_LIMIT_BINARY <= 6'b011101;
		30 : CHAN_BOND_LIMIT_BINARY <= 6'b011110;
		31 : CHAN_BOND_LIMIT_BINARY <= 6'b011111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_LIMIT on GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 31.", CHAN_BOND_LIMIT);
			$finish;
		end
	endcase

	case (CHAN_BOND_MODE)
		"NONE" : CHAN_BOND_MODE_BINARY <= 2'b00;
		"MASTER" : CHAN_BOND_MODE_BINARY <= 2'b01;
		"SLAVE_1_HOP" : CHAN_BOND_MODE_BINARY <= 2'b10;
		"SLAVE_2_HOPS" : CHAN_BOND_MODE_BINARY <= 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_MODE on GT11 instance %m is set to %s.  Legal values for this attribute are NONE, MASTER, SLAVE_1_HOP or SLAVE_2_HOPS.", CHAN_BOND_MODE);
			$finish;
		end
	endcase

	case (CHAN_BOND_ONE_SHOT)
		"FALSE" : CHAN_BOND_ONE_SHOT_BINARY <= 0;
		"TRUE" : CHAN_BOND_ONE_SHOT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_ONE_SHOT on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CHAN_BOND_ONE_SHOT);
			$finish;
		end
	endcase

	case (CHAN_BOND_SEQ_2_USE)
		"FALSE" : CHAN_BOND_SEQ_2_USE_BINARY <= 0;
		"TRUE" : CHAN_BOND_SEQ_2_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_SEQ_2_USE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CHAN_BOND_SEQ_2_USE);
			$finish;
		end
	endcase

	case (CHAN_BOND_SEQ_LEN)
		1 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b000;
		2 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b001;
		3 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b010;
		4 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b011;
		8 : CHAN_BOND_SEQ_LEN_BINARY <= 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CHAN_BOND_SEQ_LEN on GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 3, 4 or 8.", CHAN_BOND_SEQ_LEN);
			$finish;
		end
	endcase

	case (RX_BUFFER_USE)
		"FALSE" : RX_BUFFER_USE_BINARY <= 0;
		"TRUE" : RX_BUFFER_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RX_BUFFER_USE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RX_BUFFER_USE);
			$finish;
		end
	endcase

	case (TX_BUFFER_USE)
		"FALSE" : TX_BUFFER_USE_BINARY <= 0;
		"TRUE" : TX_BUFFER_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TX_BUFFER_USE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TX_BUFFER_USE);
			$finish;
		end
	endcase

	case (POWER_ENABLE)
		"FALSE" : POWER_ENABLE_BINARY <= 0;
		"TRUE" : POWER_ENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute POWER_ENABLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", POWER_ENABLE);
			$finish;
		end
	endcase

	case (OPPOSITE_SELECT)
		"FALSE" : OPPOSITE_SELECT_BINARY <= 0;
		"TRUE" : OPPOSITE_SELECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute OPPOSITE_SELECT on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", OPPOSITE_SELECT);
			$finish;
		end
	endcase

	case (CCCB_ARBITRATOR_DISABLE)
		"FALSE" : CCCB_ARBITRATOR_DISABLE_BINARY <= 0;
		"TRUE" : CCCB_ARBITRATOR_DISABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CCCB_ARBITRATOR_DISABLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CCCB_ARBITRATOR_DISABLE);
			$finish;
		end
	endcase

	case (DIGRX_SYNC_MODE)
		"FALSE" : DIGRX_SYNC_MODE_BINARY <= 0;
		"TRUE" : DIGRX_SYNC_MODE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DIGRX_SYNC_MODE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DIGRX_SYNC_MODE);
			$finish;
		end
	endcase

	case (PCS_BIT_SLIP)
		"FALSE" : PCS_BIT_SLIP_BINARY <= 0;
		"TRUE" : PCS_BIT_SLIP_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PCS_BIT_SLIP on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCS_BIT_SLIP);
			$finish;
		end
	endcase

	case (CLK_COR_MIN_LAT)
		0 : CLK_COR_MIN_LAT_BINARY <= 6'b000000;
		1 : CLK_COR_MIN_LAT_BINARY <= 6'b000001;
		2 : CLK_COR_MIN_LAT_BINARY <= 6'b000010;
		3 : CLK_COR_MIN_LAT_BINARY <= 6'b000011;
		4 : CLK_COR_MIN_LAT_BINARY <= 6'b000100;
		5 : CLK_COR_MIN_LAT_BINARY <= 6'b000101;
		6 : CLK_COR_MIN_LAT_BINARY <= 6'b000110;
		7 : CLK_COR_MIN_LAT_BINARY <= 6'b000111;
		8 : CLK_COR_MIN_LAT_BINARY <= 6'b001000;
		9 : CLK_COR_MIN_LAT_BINARY <= 6'b001001;
		10 : CLK_COR_MIN_LAT_BINARY <= 6'b001010;
		11 : CLK_COR_MIN_LAT_BINARY <= 6'b001011;
		12 : CLK_COR_MIN_LAT_BINARY <= 6'b001100;
		13 : CLK_COR_MIN_LAT_BINARY <= 6'b001101;
		14 : CLK_COR_MIN_LAT_BINARY <= 6'b001110;
		15 : CLK_COR_MIN_LAT_BINARY <= 6'b001111;
		16 : CLK_COR_MIN_LAT_BINARY <= 6'b010000;
		17 : CLK_COR_MIN_LAT_BINARY <= 6'b010001;
		18 : CLK_COR_MIN_LAT_BINARY <= 6'b010010;
		19 : CLK_COR_MIN_LAT_BINARY <= 6'b010011;
		20 : CLK_COR_MIN_LAT_BINARY <= 6'b010100;
		21 : CLK_COR_MIN_LAT_BINARY <= 6'b010101;
		22 : CLK_COR_MIN_LAT_BINARY <= 6'b010110;
		23 : CLK_COR_MIN_LAT_BINARY <= 6'b010111;
		24 : CLK_COR_MIN_LAT_BINARY <= 6'b011000;
		25 : CLK_COR_MIN_LAT_BINARY <= 6'b011001;
		26 : CLK_COR_MIN_LAT_BINARY <= 6'b011010;
		27 : CLK_COR_MIN_LAT_BINARY <= 6'b011011;
		28 : CLK_COR_MIN_LAT_BINARY <= 6'b011100;
		29 : CLK_COR_MIN_LAT_BINARY <= 6'b011101;
		30 : CLK_COR_MIN_LAT_BINARY <= 6'b011110;
		31 : CLK_COR_MIN_LAT_BINARY <= 6'b011111;
		32 : CLK_COR_MIN_LAT_BINARY <= 6'b100000;
		33 : CLK_COR_MIN_LAT_BINARY <= 6'b100001;
		34 : CLK_COR_MIN_LAT_BINARY <= 6'b100010;
		35 : CLK_COR_MIN_LAT_BINARY <= 6'b100011;
		36 : CLK_COR_MIN_LAT_BINARY <= 6'b100100;
		37 : CLK_COR_MIN_LAT_BINARY <= 6'b100101;
		38 : CLK_COR_MIN_LAT_BINARY <= 6'b100110;
		39 : CLK_COR_MIN_LAT_BINARY <= 6'b100111;
		40 : CLK_COR_MIN_LAT_BINARY <= 6'b101000;
		41 : CLK_COR_MIN_LAT_BINARY <= 6'b101001;
		42 : CLK_COR_MIN_LAT_BINARY <= 6'b101010;
		43 : CLK_COR_MIN_LAT_BINARY <= 6'b101011;
		44 : CLK_COR_MIN_LAT_BINARY <= 6'b101100;
		45 : CLK_COR_MIN_LAT_BINARY <= 6'b101101;
		46 : CLK_COR_MIN_LAT_BINARY <= 6'b101110;
		47 : CLK_COR_MIN_LAT_BINARY <= 6'b101111;
		48 : CLK_COR_MIN_LAT_BINARY <= 6'b110000;
		49 : CLK_COR_MIN_LAT_BINARY <= 6'b110001;
		50 : CLK_COR_MIN_LAT_BINARY <= 6'b110010;
		51 : CLK_COR_MIN_LAT_BINARY <= 6'b110011;
		52 : CLK_COR_MIN_LAT_BINARY <= 6'b110100;
		53 : CLK_COR_MIN_LAT_BINARY <= 6'b110101;
		54 : CLK_COR_MIN_LAT_BINARY <= 6'b110110;
		55 : CLK_COR_MIN_LAT_BINARY <= 6'b110111;
		56 : CLK_COR_MIN_LAT_BINARY <= 6'b111000;
		57 : CLK_COR_MIN_LAT_BINARY <= 6'b111001;
		58 : CLK_COR_MIN_LAT_BINARY <= 6'b111010;
		59 : CLK_COR_MIN_LAT_BINARY <= 6'b111011;
		60 : CLK_COR_MIN_LAT_BINARY <= 6'b111100;
		61 : CLK_COR_MIN_LAT_BINARY <= 6'b111101;
		62 : CLK_COR_MIN_LAT_BINARY <= 6'b111110;
		63 : CLK_COR_MIN_LAT_BINARY <= 6'b111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_MIN_LAT on GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 63.", CLK_COR_MIN_LAT);
			$finish;
		end
	endcase

	case (CLK_COR_MAX_LAT)
		0 : CLK_COR_MAX_LAT_BINARY <= 6'b000000;
		1 : CLK_COR_MAX_LAT_BINARY <= 6'b000001;
		2 : CLK_COR_MAX_LAT_BINARY <= 6'b000010;
		3 : CLK_COR_MAX_LAT_BINARY <= 6'b000011;
		4 : CLK_COR_MAX_LAT_BINARY <= 6'b000100;
		5 : CLK_COR_MAX_LAT_BINARY <= 6'b000101;
		6 : CLK_COR_MAX_LAT_BINARY <= 6'b000110;
		7 : CLK_COR_MAX_LAT_BINARY <= 6'b000111;
		8 : CLK_COR_MAX_LAT_BINARY <= 6'b001000;
		9 : CLK_COR_MAX_LAT_BINARY <= 6'b001001;
		10 : CLK_COR_MAX_LAT_BINARY <= 6'b001010;
		11 : CLK_COR_MAX_LAT_BINARY <= 6'b001011;
		12 : CLK_COR_MAX_LAT_BINARY <= 6'b001100;
		13 : CLK_COR_MAX_LAT_BINARY <= 6'b001101;
		14 : CLK_COR_MAX_LAT_BINARY <= 6'b001110;
		15 : CLK_COR_MAX_LAT_BINARY <= 6'b001111;
		16 : CLK_COR_MAX_LAT_BINARY <= 6'b010000;
		17 : CLK_COR_MAX_LAT_BINARY <= 6'b010001;
		18 : CLK_COR_MAX_LAT_BINARY <= 6'b010010;
		19 : CLK_COR_MAX_LAT_BINARY <= 6'b010011;
		20 : CLK_COR_MAX_LAT_BINARY <= 6'b010100;
		21 : CLK_COR_MAX_LAT_BINARY <= 6'b010101;
		22 : CLK_COR_MAX_LAT_BINARY <= 6'b010110;
		23 : CLK_COR_MAX_LAT_BINARY <= 6'b010111;
		24 : CLK_COR_MAX_LAT_BINARY <= 6'b011000;
		25 : CLK_COR_MAX_LAT_BINARY <= 6'b011001;
		26 : CLK_COR_MAX_LAT_BINARY <= 6'b011010;
		27 : CLK_COR_MAX_LAT_BINARY <= 6'b011011;
		28 : CLK_COR_MAX_LAT_BINARY <= 6'b011100;
		29 : CLK_COR_MAX_LAT_BINARY <= 6'b011101;
		30 : CLK_COR_MAX_LAT_BINARY <= 6'b011110;
		31 : CLK_COR_MAX_LAT_BINARY <= 6'b011111;
		32 : CLK_COR_MAX_LAT_BINARY <= 6'b100000;
		33 : CLK_COR_MAX_LAT_BINARY <= 6'b100001;
		34 : CLK_COR_MAX_LAT_BINARY <= 6'b100010;
		35 : CLK_COR_MAX_LAT_BINARY <= 6'b100011;
		36 : CLK_COR_MAX_LAT_BINARY <= 6'b100100;
		37 : CLK_COR_MAX_LAT_BINARY <= 6'b100101;
		38 : CLK_COR_MAX_LAT_BINARY <= 6'b100110;
		39 : CLK_COR_MAX_LAT_BINARY <= 6'b100111;
		40 : CLK_COR_MAX_LAT_BINARY <= 6'b101000;
		41 : CLK_COR_MAX_LAT_BINARY <= 6'b101001;
		42 : CLK_COR_MAX_LAT_BINARY <= 6'b101010;
		43 : CLK_COR_MAX_LAT_BINARY <= 6'b101011;
		44 : CLK_COR_MAX_LAT_BINARY <= 6'b101100;
		45 : CLK_COR_MAX_LAT_BINARY <= 6'b101101;
		46 : CLK_COR_MAX_LAT_BINARY <= 6'b101110;
		47 : CLK_COR_MAX_LAT_BINARY <= 6'b101111;
		48 : CLK_COR_MAX_LAT_BINARY <= 6'b110000;
		49 : CLK_COR_MAX_LAT_BINARY <= 6'b110001;
		50 : CLK_COR_MAX_LAT_BINARY <= 6'b110010;
		51 : CLK_COR_MAX_LAT_BINARY <= 6'b110011;
		52 : CLK_COR_MAX_LAT_BINARY <= 6'b110100;
		53 : CLK_COR_MAX_LAT_BINARY <= 6'b110101;
		54 : CLK_COR_MAX_LAT_BINARY <= 6'b110110;
		55 : CLK_COR_MAX_LAT_BINARY <= 6'b110111;
		56 : CLK_COR_MAX_LAT_BINARY <= 6'b111000;
		57 : CLK_COR_MAX_LAT_BINARY <= 6'b111001;
		58 : CLK_COR_MAX_LAT_BINARY <= 6'b111010;
		59 : CLK_COR_MAX_LAT_BINARY <= 6'b111011;
		60 : CLK_COR_MAX_LAT_BINARY <= 6'b111100;
		61 : CLK_COR_MAX_LAT_BINARY <= 6'b111101;
		62 : CLK_COR_MAX_LAT_BINARY <= 6'b111110;
		63 : CLK_COR_MAX_LAT_BINARY <= 6'b111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_MAX_LAT on GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 63.", CLK_COR_MAX_LAT);
			$finish;
		end
	endcase

	case (CLK_COR_SEQ_2_USE)
		"FALSE" : CLK_COR_SEQ_2_USE_BINARY <= 0;
		"TRUE" : CLK_COR_SEQ_2_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_SEQ_2_USE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLK_COR_SEQ_2_USE);
			$finish;
		end
	endcase

	case (CLK_COR_SEQ_DROP)
		"FALSE" : CLK_COR_SEQ_DROP_BINARY <= 0;
		"TRUE" : CLK_COR_SEQ_DROP_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_SEQ_DROP on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLK_COR_SEQ_DROP);
			$finish;
		end
	endcase

	case (CLK_COR_SEQ_LEN)
		1 : CLK_COR_SEQ_LEN_BINARY <= 3'b000;
		2 : CLK_COR_SEQ_LEN_BINARY <= 3'b001;
		3 : CLK_COR_SEQ_LEN_BINARY <= 3'b010;
		4 : CLK_COR_SEQ_LEN_BINARY <= 3'b011;
		8 : CLK_COR_SEQ_LEN_BINARY <= 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_SEQ_LEN on GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 3, 4 or 8.", CLK_COR_SEQ_LEN);
			$finish;
		end
	endcase

	case (CLK_CORRECT_USE)
		"FALSE" : CLK_CORRECT_USE_BINARY <= 0;
		"TRUE" : CLK_CORRECT_USE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_CORRECT_USE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLK_CORRECT_USE);
			$finish;
		end
	endcase

	case (CLK_COR_8B10B_DE)
		"FALSE" : CLK_COR_8B10B_DE_BINARY <= 0;
		"TRUE" : CLK_COR_8B10B_DE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLK_COR_8B10B_DE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLK_COR_8B10B_DE);
			$finish;
		end
	endcase

	case (SH_CNT_MAX)
		0 : SH_CNT_MAX_BINARY <= 8'b00000000;
		1 : SH_CNT_MAX_BINARY <= 8'b00000001;
		2 : SH_CNT_MAX_BINARY <= 8'b00000010;
		3 : SH_CNT_MAX_BINARY <= 8'b00000011;
		4 : SH_CNT_MAX_BINARY <= 8'b00000100;
		5 : SH_CNT_MAX_BINARY <= 8'b00000101;
		6 : SH_CNT_MAX_BINARY <= 8'b00000110;
		7 : SH_CNT_MAX_BINARY <= 8'b00000111;
		8 : SH_CNT_MAX_BINARY <= 8'b00001000;
		9 : SH_CNT_MAX_BINARY <= 8'b00001001;
		10 : SH_CNT_MAX_BINARY <= 8'b00001010;
		11 : SH_CNT_MAX_BINARY <= 8'b00001011;
		12 : SH_CNT_MAX_BINARY <= 8'b00001100;
		13 : SH_CNT_MAX_BINARY <= 8'b00001101;
		14 : SH_CNT_MAX_BINARY <= 8'b00001110;
		15 : SH_CNT_MAX_BINARY <= 8'b00001111;
		16 : SH_CNT_MAX_BINARY <= 8'b00010000;
		17 : SH_CNT_MAX_BINARY <= 8'b00010001;
		18 : SH_CNT_MAX_BINARY <= 8'b00010010;
		19 : SH_CNT_MAX_BINARY <= 8'b00010011;
		20 : SH_CNT_MAX_BINARY <= 8'b00010100;
		21 : SH_CNT_MAX_BINARY <= 8'b00010101;
		22 : SH_CNT_MAX_BINARY <= 8'b00010110;
		23 : SH_CNT_MAX_BINARY <= 8'b00010111;
		24 : SH_CNT_MAX_BINARY <= 8'b00011000;
		25 : SH_CNT_MAX_BINARY <= 8'b00011001;
		26 : SH_CNT_MAX_BINARY <= 8'b00011010;
		27 : SH_CNT_MAX_BINARY <= 8'b00011011;
		28 : SH_CNT_MAX_BINARY <= 8'b00011100;
		29 : SH_CNT_MAX_BINARY <= 8'b00011101;
		30 : SH_CNT_MAX_BINARY <= 8'b00011110;
		31 : SH_CNT_MAX_BINARY <= 8'b00011111;
		32 : SH_CNT_MAX_BINARY <= 8'b00100000;
		33 : SH_CNT_MAX_BINARY <= 8'b00100001;
		34 : SH_CNT_MAX_BINARY <= 8'b00100010;
		35 : SH_CNT_MAX_BINARY <= 8'b00100011;
		36 : SH_CNT_MAX_BINARY <= 8'b00100100;
		37 : SH_CNT_MAX_BINARY <= 8'b00100101;
		38 : SH_CNT_MAX_BINARY <= 8'b00100110;
		39 : SH_CNT_MAX_BINARY <= 8'b00100111;
		40 : SH_CNT_MAX_BINARY <= 8'b00101000;
		41 : SH_CNT_MAX_BINARY <= 8'b00101001;
		42 : SH_CNT_MAX_BINARY <= 8'b00101010;
		43 : SH_CNT_MAX_BINARY <= 8'b00101011;
		44 : SH_CNT_MAX_BINARY <= 8'b00101100;
		45 : SH_CNT_MAX_BINARY <= 8'b00101101;
		46 : SH_CNT_MAX_BINARY <= 8'b00101110;
		47 : SH_CNT_MAX_BINARY <= 8'b00101111;
		48 : SH_CNT_MAX_BINARY <= 8'b00110000;
		49 : SH_CNT_MAX_BINARY <= 8'b00110001;
		50 : SH_CNT_MAX_BINARY <= 8'b00110010;
		51 : SH_CNT_MAX_BINARY <= 8'b00110011;
		52 : SH_CNT_MAX_BINARY <= 8'b00110100;
		53 : SH_CNT_MAX_BINARY <= 8'b00110101;
		54 : SH_CNT_MAX_BINARY <= 8'b00110110;
		55 : SH_CNT_MAX_BINARY <= 8'b00110111;
		56 : SH_CNT_MAX_BINARY <= 8'b00111000;
		57 : SH_CNT_MAX_BINARY <= 8'b00111001;
		58 : SH_CNT_MAX_BINARY <= 8'b00111010;
		59 : SH_CNT_MAX_BINARY <= 8'b00111011;
		60 : SH_CNT_MAX_BINARY <= 8'b00111100;
		61 : SH_CNT_MAX_BINARY <= 8'b00111101;
		62 : SH_CNT_MAX_BINARY <= 8'b00111110;
		63 : SH_CNT_MAX_BINARY <= 8'b00111111;
		64 : SH_CNT_MAX_BINARY <= 8'b01000000;
		65 : SH_CNT_MAX_BINARY <= 8'b01000001;
		66 : SH_CNT_MAX_BINARY <= 8'b01000010;
		67 : SH_CNT_MAX_BINARY <= 8'b01000011;
		68 : SH_CNT_MAX_BINARY <= 8'b01000100;
		69 : SH_CNT_MAX_BINARY <= 8'b01000101;
		70 : SH_CNT_MAX_BINARY <= 8'b01000110;
		71 : SH_CNT_MAX_BINARY <= 8'b01000111;
		72 : SH_CNT_MAX_BINARY <= 8'b01001000;
		73 : SH_CNT_MAX_BINARY <= 8'b01001001;
		74 : SH_CNT_MAX_BINARY <= 8'b01001010;
		75 : SH_CNT_MAX_BINARY <= 8'b01001011;
		76 : SH_CNT_MAX_BINARY <= 8'b01001100;
		77 : SH_CNT_MAX_BINARY <= 8'b01001101;
		78 : SH_CNT_MAX_BINARY <= 8'b01001110;
		79 : SH_CNT_MAX_BINARY <= 8'b01001111;
		80 : SH_CNT_MAX_BINARY <= 8'b01010000;
		81 : SH_CNT_MAX_BINARY <= 8'b01010001;
		82 : SH_CNT_MAX_BINARY <= 8'b01010010;
		83 : SH_CNT_MAX_BINARY <= 8'b01010011;
		84 : SH_CNT_MAX_BINARY <= 8'b01010100;
		85 : SH_CNT_MAX_BINARY <= 8'b01010101;
		86 : SH_CNT_MAX_BINARY <= 8'b01010110;
		87 : SH_CNT_MAX_BINARY <= 8'b01010111;
		88 : SH_CNT_MAX_BINARY <= 8'b01011000;
		89 : SH_CNT_MAX_BINARY <= 8'b01011001;
		90 : SH_CNT_MAX_BINARY <= 8'b01011010;
		91 : SH_CNT_MAX_BINARY <= 8'b01011011;
		92 : SH_CNT_MAX_BINARY <= 8'b01011100;
		93 : SH_CNT_MAX_BINARY <= 8'b01011101;
		94 : SH_CNT_MAX_BINARY <= 8'b01011110;
		95 : SH_CNT_MAX_BINARY <= 8'b01011111;
		96 : SH_CNT_MAX_BINARY <= 8'b01100000;
		97 : SH_CNT_MAX_BINARY <= 8'b01100001;
		98 : SH_CNT_MAX_BINARY <= 8'b01100010;
		99 : SH_CNT_MAX_BINARY <= 8'b01100011;
		100 : SH_CNT_MAX_BINARY <= 8'b01100100;
		101 : SH_CNT_MAX_BINARY <= 8'b01100101;
		102 : SH_CNT_MAX_BINARY <= 8'b01100110;
		103 : SH_CNT_MAX_BINARY <= 8'b01100111;
		104 : SH_CNT_MAX_BINARY <= 8'b01101000;
		105 : SH_CNT_MAX_BINARY <= 8'b01101001;
		106 : SH_CNT_MAX_BINARY <= 8'b01101010;
		107 : SH_CNT_MAX_BINARY <= 8'b01101011;
		108 : SH_CNT_MAX_BINARY <= 8'b01101100;
		109 : SH_CNT_MAX_BINARY <= 8'b01101101;
		110 : SH_CNT_MAX_BINARY <= 8'b01101110;
		111 : SH_CNT_MAX_BINARY <= 8'b01101111;
		112 : SH_CNT_MAX_BINARY <= 8'b01110000;
		113 : SH_CNT_MAX_BINARY <= 8'b01110001;
		114 : SH_CNT_MAX_BINARY <= 8'b01110010;
		115 : SH_CNT_MAX_BINARY <= 8'b01110011;
		116 : SH_CNT_MAX_BINARY <= 8'b01110100;
		117 : SH_CNT_MAX_BINARY <= 8'b01110101;
		118 : SH_CNT_MAX_BINARY <= 8'b01110110;
		119 : SH_CNT_MAX_BINARY <= 8'b01110111;
		120 : SH_CNT_MAX_BINARY <= 8'b01111000;
		121 : SH_CNT_MAX_BINARY <= 8'b01111001;
		122 : SH_CNT_MAX_BINARY <= 8'b01111010;
		123 : SH_CNT_MAX_BINARY <= 8'b01111011;
		124 : SH_CNT_MAX_BINARY <= 8'b01111100;
		125 : SH_CNT_MAX_BINARY <= 8'b01111101;
		126 : SH_CNT_MAX_BINARY <= 8'b01111110;
		127 : SH_CNT_MAX_BINARY <= 8'b01111111;
		128 : SH_CNT_MAX_BINARY <= 8'b10000000;
		129 : SH_CNT_MAX_BINARY <= 8'b10000001;
		130 : SH_CNT_MAX_BINARY <= 8'b10000010;
		131 : SH_CNT_MAX_BINARY <= 8'b10000011;
		132 : SH_CNT_MAX_BINARY <= 8'b10000100;
		133 : SH_CNT_MAX_BINARY <= 8'b10000101;
		134 : SH_CNT_MAX_BINARY <= 8'b10000110;
		135 : SH_CNT_MAX_BINARY <= 8'b10000111;
		136 : SH_CNT_MAX_BINARY <= 8'b10001000;
		137 : SH_CNT_MAX_BINARY <= 8'b10001001;
		138 : SH_CNT_MAX_BINARY <= 8'b10001010;
		139 : SH_CNT_MAX_BINARY <= 8'b10001011;
		140 : SH_CNT_MAX_BINARY <= 8'b10001100;
		141 : SH_CNT_MAX_BINARY <= 8'b10001101;
		142 : SH_CNT_MAX_BINARY <= 8'b10001110;
		143 : SH_CNT_MAX_BINARY <= 8'b10001111;
		144 : SH_CNT_MAX_BINARY <= 8'b10010000;
		145 : SH_CNT_MAX_BINARY <= 8'b10010001;
		146 : SH_CNT_MAX_BINARY <= 8'b10010010;
		147 : SH_CNT_MAX_BINARY <= 8'b10010011;
		148 : SH_CNT_MAX_BINARY <= 8'b10010100;
		149 : SH_CNT_MAX_BINARY <= 8'b10010101;
		150 : SH_CNT_MAX_BINARY <= 8'b10010110;
		151 : SH_CNT_MAX_BINARY <= 8'b10010111;
		152 : SH_CNT_MAX_BINARY <= 8'b10011000;
		153 : SH_CNT_MAX_BINARY <= 8'b10011001;
		154 : SH_CNT_MAX_BINARY <= 8'b10011010;
		155 : SH_CNT_MAX_BINARY <= 8'b10011011;
		156 : SH_CNT_MAX_BINARY <= 8'b10011100;
		157 : SH_CNT_MAX_BINARY <= 8'b10011101;
		158 : SH_CNT_MAX_BINARY <= 8'b10011110;
		159 : SH_CNT_MAX_BINARY <= 8'b10011111;
		160 : SH_CNT_MAX_BINARY <= 8'b10100000;
		161 : SH_CNT_MAX_BINARY <= 8'b10100001;
		162 : SH_CNT_MAX_BINARY <= 8'b10100010;
		163 : SH_CNT_MAX_BINARY <= 8'b10100011;
		164 : SH_CNT_MAX_BINARY <= 8'b10100100;
		165 : SH_CNT_MAX_BINARY <= 8'b10100101;
		166 : SH_CNT_MAX_BINARY <= 8'b10100110;
		167 : SH_CNT_MAX_BINARY <= 8'b10100111;
		168 : SH_CNT_MAX_BINARY <= 8'b10101000;
		169 : SH_CNT_MAX_BINARY <= 8'b10101001;
		170 : SH_CNT_MAX_BINARY <= 8'b10101010;
		171 : SH_CNT_MAX_BINARY <= 8'b10101011;
		172 : SH_CNT_MAX_BINARY <= 8'b10101100;
		173 : SH_CNT_MAX_BINARY <= 8'b10101101;
		174 : SH_CNT_MAX_BINARY <= 8'b10101110;
		175 : SH_CNT_MAX_BINARY <= 8'b10101111;
		176 : SH_CNT_MAX_BINARY <= 8'b10110000;
		177 : SH_CNT_MAX_BINARY <= 8'b10110001;
		178 : SH_CNT_MAX_BINARY <= 8'b10110010;
		179 : SH_CNT_MAX_BINARY <= 8'b10110011;
		180 : SH_CNT_MAX_BINARY <= 8'b10110100;
		181 : SH_CNT_MAX_BINARY <= 8'b10110101;
		182 : SH_CNT_MAX_BINARY <= 8'b10110110;
		183 : SH_CNT_MAX_BINARY <= 8'b10110111;
		184 : SH_CNT_MAX_BINARY <= 8'b10111000;
		185 : SH_CNT_MAX_BINARY <= 8'b10111001;
		186 : SH_CNT_MAX_BINARY <= 8'b10111010;
		187 : SH_CNT_MAX_BINARY <= 8'b10111011;
		188 : SH_CNT_MAX_BINARY <= 8'b10111100;
		189 : SH_CNT_MAX_BINARY <= 8'b10111101;
		190 : SH_CNT_MAX_BINARY <= 8'b10111110;
		191 : SH_CNT_MAX_BINARY <= 8'b10111111;
		192 : SH_CNT_MAX_BINARY <= 8'b11000000;
		193 : SH_CNT_MAX_BINARY <= 8'b11000001;
		194 : SH_CNT_MAX_BINARY <= 8'b11000010;
		195 : SH_CNT_MAX_BINARY <= 8'b11000011;
		196 : SH_CNT_MAX_BINARY <= 8'b11000100;
		197 : SH_CNT_MAX_BINARY <= 8'b11000101;
		198 : SH_CNT_MAX_BINARY <= 8'b11000110;
		199 : SH_CNT_MAX_BINARY <= 8'b11000111;
		200 : SH_CNT_MAX_BINARY <= 8'b11001000;
		201 : SH_CNT_MAX_BINARY <= 8'b11001001;
		202 : SH_CNT_MAX_BINARY <= 8'b11001010;
		203 : SH_CNT_MAX_BINARY <= 8'b11001011;
		204 : SH_CNT_MAX_BINARY <= 8'b11001100;
		205 : SH_CNT_MAX_BINARY <= 8'b11001101;
		206 : SH_CNT_MAX_BINARY <= 8'b11001110;
		207 : SH_CNT_MAX_BINARY <= 8'b11001111;
		208 : SH_CNT_MAX_BINARY <= 8'b11010000;
		209 : SH_CNT_MAX_BINARY <= 8'b11010001;
		210 : SH_CNT_MAX_BINARY <= 8'b11010010;
		211 : SH_CNT_MAX_BINARY <= 8'b11010011;
		212 : SH_CNT_MAX_BINARY <= 8'b11010100;
		213 : SH_CNT_MAX_BINARY <= 8'b11010101;
		214 : SH_CNT_MAX_BINARY <= 8'b11010110;
		215 : SH_CNT_MAX_BINARY <= 8'b11010111;
		216 : SH_CNT_MAX_BINARY <= 8'b11011000;
		217 : SH_CNT_MAX_BINARY <= 8'b11011001;
		218 : SH_CNT_MAX_BINARY <= 8'b11011010;
		219 : SH_CNT_MAX_BINARY <= 8'b11011011;
		220 : SH_CNT_MAX_BINARY <= 8'b11011100;
		221 : SH_CNT_MAX_BINARY <= 8'b11011101;
		222 : SH_CNT_MAX_BINARY <= 8'b11011110;
		223 : SH_CNT_MAX_BINARY <= 8'b11011111;
		224 : SH_CNT_MAX_BINARY <= 8'b11100000;
		225 : SH_CNT_MAX_BINARY <= 8'b11100001;
		226 : SH_CNT_MAX_BINARY <= 8'b11100010;
		227 : SH_CNT_MAX_BINARY <= 8'b11100011;
		228 : SH_CNT_MAX_BINARY <= 8'b11100100;
		229 : SH_CNT_MAX_BINARY <= 8'b11100101;
		230 : SH_CNT_MAX_BINARY <= 8'b11100110;
		231 : SH_CNT_MAX_BINARY <= 8'b11100111;
		232 : SH_CNT_MAX_BINARY <= 8'b11101000;
		233 : SH_CNT_MAX_BINARY <= 8'b11101001;
		234 : SH_CNT_MAX_BINARY <= 8'b11101010;
		235 : SH_CNT_MAX_BINARY <= 8'b11101011;
		236 : SH_CNT_MAX_BINARY <= 8'b11101100;
		237 : SH_CNT_MAX_BINARY <= 8'b11101101;
		238 : SH_CNT_MAX_BINARY <= 8'b11101110;
		239 : SH_CNT_MAX_BINARY <= 8'b11101111;
		240 : SH_CNT_MAX_BINARY <= 8'b11110000;
		241 : SH_CNT_MAX_BINARY <= 8'b11110001;
		242 : SH_CNT_MAX_BINARY <= 8'b11110010;
		243 : SH_CNT_MAX_BINARY <= 8'b11110011;
		244 : SH_CNT_MAX_BINARY <= 8'b11110100;
		245 : SH_CNT_MAX_BINARY <= 8'b11110101;
		246 : SH_CNT_MAX_BINARY <= 8'b11110110;
		247 : SH_CNT_MAX_BINARY <= 8'b11110111;
		248 : SH_CNT_MAX_BINARY <= 8'b11111000;
		249 : SH_CNT_MAX_BINARY <= 8'b11111001;
		250 : SH_CNT_MAX_BINARY <= 8'b11111010;
		251 : SH_CNT_MAX_BINARY <= 8'b11111011;
		252 : SH_CNT_MAX_BINARY <= 8'b11111100;
		253 : SH_CNT_MAX_BINARY <= 8'b11111101;
		254 : SH_CNT_MAX_BINARY <= 8'b11111110;
		255 : SH_CNT_MAX_BINARY <= 8'b11111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute SH_CNT_MAX on GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 255.", SH_CNT_MAX);
			$finish;
		end
	endcase

	case (SH_INVALID_CNT_MAX)
		0 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000000;
		1 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000001;
		2 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000010;
		3 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000011;
		4 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000100;
		5 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000101;
		6 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000110;
		7 : SH_INVALID_CNT_MAX_BINARY <= 8'b00000111;
		8 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001000;
		9 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001001;
		10 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001010;
		11 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001011;
		12 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001100;
		13 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001101;
		14 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001110;
		15 : SH_INVALID_CNT_MAX_BINARY <= 8'b00001111;
		16 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010000;
		17 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010001;
		18 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010010;
		19 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010011;
		20 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010100;
		21 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010101;
		22 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010110;
		23 : SH_INVALID_CNT_MAX_BINARY <= 8'b00010111;
		24 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011000;
		25 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011001;
		26 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011010;
		27 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011011;
		28 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011100;
		29 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011101;
		30 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011110;
		31 : SH_INVALID_CNT_MAX_BINARY <= 8'b00011111;
		32 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100000;
		33 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100001;
		34 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100010;
		35 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100011;
		36 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100100;
		37 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100101;
		38 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100110;
		39 : SH_INVALID_CNT_MAX_BINARY <= 8'b00100111;
		40 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101000;
		41 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101001;
		42 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101010;
		43 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101011;
		44 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101100;
		45 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101101;
		46 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101110;
		47 : SH_INVALID_CNT_MAX_BINARY <= 8'b00101111;
		48 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110000;
		49 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110001;
		50 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110010;
		51 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110011;
		52 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110100;
		53 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110101;
		54 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110110;
		55 : SH_INVALID_CNT_MAX_BINARY <= 8'b00110111;
		56 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111000;
		57 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111001;
		58 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111010;
		59 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111011;
		60 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111100;
		61 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111101;
		62 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111110;
		63 : SH_INVALID_CNT_MAX_BINARY <= 8'b00111111;
		64 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000000;
		65 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000001;
		66 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000010;
		67 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000011;
		68 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000100;
		69 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000101;
		70 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000110;
		71 : SH_INVALID_CNT_MAX_BINARY <= 8'b01000111;
		72 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001000;
		73 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001001;
		74 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001010;
		75 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001011;
		76 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001100;
		77 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001101;
		78 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001110;
		79 : SH_INVALID_CNT_MAX_BINARY <= 8'b01001111;
		80 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010000;
		81 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010001;
		82 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010010;
		83 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010011;
		84 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010100;
		85 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010101;
		86 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010110;
		87 : SH_INVALID_CNT_MAX_BINARY <= 8'b01010111;
		88 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011000;
		89 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011001;
		90 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011010;
		91 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011011;
		92 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011100;
		93 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011101;
		94 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011110;
		95 : SH_INVALID_CNT_MAX_BINARY <= 8'b01011111;
		96 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100000;
		97 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100001;
		98 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100010;
		99 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100011;
		100 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100100;
		101 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100101;
		102 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100110;
		103 : SH_INVALID_CNT_MAX_BINARY <= 8'b01100111;
		104 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101000;
		105 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101001;
		106 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101010;
		107 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101011;
		108 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101100;
		109 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101101;
		110 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101110;
		111 : SH_INVALID_CNT_MAX_BINARY <= 8'b01101111;
		112 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110000;
		113 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110001;
		114 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110010;
		115 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110011;
		116 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110100;
		117 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110101;
		118 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110110;
		119 : SH_INVALID_CNT_MAX_BINARY <= 8'b01110111;
		120 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111000;
		121 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111001;
		122 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111010;
		123 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111011;
		124 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111100;
		125 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111101;
		126 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111110;
		127 : SH_INVALID_CNT_MAX_BINARY <= 8'b01111111;
		128 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000000;
		129 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000001;
		130 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000010;
		131 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000011;
		132 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000100;
		133 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000101;
		134 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000110;
		135 : SH_INVALID_CNT_MAX_BINARY <= 8'b10000111;
		136 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001000;
		137 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001001;
		138 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001010;
		139 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001011;
		140 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001100;
		141 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001101;
		142 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001110;
		143 : SH_INVALID_CNT_MAX_BINARY <= 8'b10001111;
		144 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010000;
		145 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010001;
		146 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010010;
		147 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010011;
		148 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010100;
		149 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010101;
		150 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010110;
		151 : SH_INVALID_CNT_MAX_BINARY <= 8'b10010111;
		152 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011000;
		153 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011001;
		154 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011010;
		155 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011011;
		156 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011100;
		157 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011101;
		158 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011110;
		159 : SH_INVALID_CNT_MAX_BINARY <= 8'b10011111;
		160 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100000;
		161 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100001;
		162 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100010;
		163 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100011;
		164 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100100;
		165 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100101;
		166 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100110;
		167 : SH_INVALID_CNT_MAX_BINARY <= 8'b10100111;
		168 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101000;
		169 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101001;
		170 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101010;
		171 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101011;
		172 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101100;
		173 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101101;
		174 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101110;
		175 : SH_INVALID_CNT_MAX_BINARY <= 8'b10101111;
		176 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110000;
		177 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110001;
		178 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110010;
		179 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110011;
		180 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110100;
		181 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110101;
		182 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110110;
		183 : SH_INVALID_CNT_MAX_BINARY <= 8'b10110111;
		184 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111000;
		185 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111001;
		186 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111010;
		187 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111011;
		188 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111100;
		189 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111101;
		190 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111110;
		191 : SH_INVALID_CNT_MAX_BINARY <= 8'b10111111;
		192 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000000;
		193 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000001;
		194 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000010;
		195 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000011;
		196 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000100;
		197 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000101;
		198 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000110;
		199 : SH_INVALID_CNT_MAX_BINARY <= 8'b11000111;
		200 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001000;
		201 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001001;
		202 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001010;
		203 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001011;
		204 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001100;
		205 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001101;
		206 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001110;
		207 : SH_INVALID_CNT_MAX_BINARY <= 8'b11001111;
		208 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010000;
		209 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010001;
		210 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010010;
		211 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010011;
		212 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010100;
		213 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010101;
		214 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010110;
		215 : SH_INVALID_CNT_MAX_BINARY <= 8'b11010111;
		216 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011000;
		217 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011001;
		218 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011010;
		219 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011011;
		220 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011100;
		221 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011101;
		222 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011110;
		223 : SH_INVALID_CNT_MAX_BINARY <= 8'b11011111;
		224 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100000;
		225 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100001;
		226 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100010;
		227 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100011;
		228 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100100;
		229 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100101;
		230 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100110;
		231 : SH_INVALID_CNT_MAX_BINARY <= 8'b11100111;
		232 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101000;
		233 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101001;
		234 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101010;
		235 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101011;
		236 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101100;
		237 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101101;
		238 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101110;
		239 : SH_INVALID_CNT_MAX_BINARY <= 8'b11101111;
		240 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110000;
		241 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110001;
		242 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110010;
		243 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110011;
		244 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110100;
		245 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110101;
		246 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110110;
		247 : SH_INVALID_CNT_MAX_BINARY <= 8'b11110111;
		248 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111000;
		249 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111001;
		250 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111010;
		251 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111011;
		252 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111100;
		253 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111101;
		254 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111110;
		255 : SH_INVALID_CNT_MAX_BINARY <= 8'b11111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute SH_INVALID_CNT_MAX on GT11 instance %m is set to %d.  Legal values for this attribute are 0 to 255.", SH_INVALID_CNT_MAX);
			$finish;
		end
	endcase

	case (ALIGN_COMMA_WORD)
		1 : ALIGN_COMMA_WORD_BINARY <= 2'b00;
		2 : ALIGN_COMMA_WORD_BINARY <= 2'b01;
		4 : ALIGN_COMMA_WORD_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute ALIGN_COMMA_WORD on GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2 or 4.", ALIGN_COMMA_WORD);
			$finish;
		end
	endcase

	case (DEC_MCOMMA_DETECT)
		"FALSE" : DEC_MCOMMA_DETECT_BINARY <= 0;
		"TRUE" : DEC_MCOMMA_DETECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DEC_MCOMMA_DETECT on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEC_MCOMMA_DETECT);
			$finish;
		end
	endcase

	case (DEC_PCOMMA_DETECT)
		"FALSE" : DEC_PCOMMA_DETECT_BINARY <= 0;
		"TRUE" : DEC_PCOMMA_DETECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DEC_PCOMMA_DETECT on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEC_PCOMMA_DETECT);
			$finish;
		end
	endcase

	case (DEC_VALID_COMMA_ONLY)
		"FALSE" : DEC_VALID_COMMA_ONLY_BINARY <= 0;
		"TRUE" : DEC_VALID_COMMA_ONLY_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DEC_VALID_COMMA_ONLY on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEC_VALID_COMMA_ONLY);
			$finish;
		end
	endcase

	case (MCOMMA_DETECT)
		"FALSE" : MCOMMA_DETECT_BINARY <= 0;
		"TRUE" : MCOMMA_DETECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute MCOMMA_DETECT on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MCOMMA_DETECT);
			$finish;
		end
	endcase

	case (PCOMMA_DETECT)
		"FALSE" : PCOMMA_DETECT_BINARY <= 0;
		"TRUE" : PCOMMA_DETECT_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PCOMMA_DETECT on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCOMMA_DETECT);
			$finish;
		end
	endcase

	case (COMMA32)
		"FALSE" : COMMA32_BINARY <= 0;
		"TRUE" : COMMA32_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute COMMA32 on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", COMMA32);
			$finish;
		end
	endcase

	case (RXUSRDIVISOR)
		1 : RXUSRDIVISOR_BINARY <= 5'b00001;
		2 : RXUSRDIVISOR_BINARY <= 5'b00010;
		4 : RXUSRDIVISOR_BINARY <= 5'b00100;
		8 : RXUSRDIVISOR_BINARY <= 5'b01000;
		16 : RXUSRDIVISOR_BINARY <= 5'b10000;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXUSRDIVISOR on GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 4, 8 or 16.", RXUSRDIVISOR);
			$finish;
		end
	endcase

	case (SAMPLE_8X)
		"FALSE" : SAMPLE_8X_BINARY <= 0;
		"TRUE" : SAMPLE_8X_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SAMPLE_8X on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SAMPLE_8X);
			$finish;
		end
	endcase

	case (ENABLE_DCDR)
		"FALSE" : ENABLE_DCDR_BINARY <= 0;
		"TRUE" : ENABLE_DCDR_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute ENABLE_DCDR on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ENABLE_DCDR);
			$finish;
		end
	endcase

	case (REPEATER)
		"FALSE" : REPEATER_BINARY <= 0;
		"TRUE" : REPEATER_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute REPEATER on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", REPEATER);
			$finish;
		end
	endcase

	case (RXBY_32)
		"FALSE" : RXBY_32_BINARY <= 0;
		"TRUE" : RXBY_32_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXBY_32 on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXBY_32);
			$finish;
		end
	endcase

	case (TXFDCAL_CLOCK_DIVIDE)
		"NONE" : TXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b00;
		"TWO" : TXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b01;
		"FOUR" : TXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXFDCAL_CLOCK_DIVIDE on GT11 instance %m is set to %s.  Legal values for this attribute are NONE, TWO or FOUR.", TXFDCAL_CLOCK_DIVIDE);
			$finish;
		end
	endcase

	case (RXFDCAL_CLOCK_DIVIDE)
		"NONE" : RXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b00;
		"TWO" : RXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b01;
		"FOUR" : RXFDCAL_CLOCK_DIVIDE_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXFDCAL_CLOCK_DIVIDE on GT11 instance %m is set to %s.  Legal values for this attribute are NONE, TWO or FOUR.", RXFDCAL_CLOCK_DIVIDE);
			$finish;
		end
	endcase

	case (RXVCO_CTRL_ENABLE)
		"FALSE" : RXVCO_CTRL_ENABLE_BINARY <= 0;
		"TRUE" : RXVCO_CTRL_ENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXVCO_CTRL_ENABLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXVCO_CTRL_ENABLE);
			$finish;
		end
	endcase

	case (VCO_CTRL_ENABLE)
		"FALSE" : VCO_CTRL_ENABLE_BINARY <= 0;
		"TRUE" : VCO_CTRL_ENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute VCO_CTRL_ENABLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VCO_CTRL_ENABLE);
			$finish;
		end
	endcase

	case (RXCRCCLOCKDOUBLE)
		"FALSE" : RXCRCCLOCKDOUBLE_BINARY <= 0;
		"TRUE" : RXCRCCLOCKDOUBLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCRCCLOCKDOUBLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCRCCLOCKDOUBLE);
			$finish;
		end
	endcase

	case (RXCRCINVERTGEN)
		"FALSE" : RXCRCINVERTGEN_BINARY <= 0;
		"TRUE" : RXCRCINVERTGEN_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCRCINVERTGEN on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCRCINVERTGEN);
			$finish;
		end
	endcase

	case (RXCRCSAMECLOCK)
		"FALSE" : RXCRCSAMECLOCK_BINARY <= 0;
		"TRUE" : RXCRCSAMECLOCK_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCRCSAMECLOCK on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCRCSAMECLOCK);
			$finish;
		end
	endcase

	case (RXCRCENABLE)
		"FALSE" : RXCRCENABLE_BINARY <= 0;
		"TRUE" : RXCRCENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCRCENABLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCRCENABLE);
			$finish;
		end
	endcase

	case (TXCRCCLOCKDOUBLE)
		"FALSE" : TXCRCCLOCKDOUBLE_BINARY <= 0;
		"TRUE" : TXCRCCLOCKDOUBLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCRCCLOCKDOUBLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCRCCLOCKDOUBLE);
			$finish;
		end
	endcase

	case (TXCRCINVERTGEN)
		"FALSE" : TXCRCINVERTGEN_BINARY <= 0;
		"TRUE" : TXCRCINVERTGEN_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCRCINVERTGEN on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCRCINVERTGEN);
			$finish;
		end
	endcase

	case (TXCRCSAMECLOCK)
		"FALSE" : TXCRCSAMECLOCK_BINARY <= 0;
		"TRUE" : TXCRCSAMECLOCK_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCRCSAMECLOCK on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCRCSAMECLOCK);
			$finish;
		end
	endcase

	case (TXCRCENABLE)
		"FALSE" : TXCRCENABLE_BINARY <= 0;
		"TRUE" : TXCRCENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCRCENABLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCRCENABLE);
			$finish;
		end
	endcase

	case (RXCLK0_FORCE_PMACLK)
		"FALSE" : RXCLK0_FORCE_PMACLK_BINARY <= 0;
		"TRUE" : RXCLK0_FORCE_PMACLK_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCLK0_FORCE_PMACLK on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCLK0_FORCE_PMACLK);
			$finish;
		end
	endcase

	case (TXCLK0_FORCE_PMACLK)
		"FALSE" : TXCLK0_FORCE_PMACLK_BINARY <= 0;
		"TRUE" : TXCLK0_FORCE_PMACLK_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCLK0_FORCE_PMACLK on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCLK0_FORCE_PMACLK);
			$finish;
		end
	endcase

	case (TXOUTCLK1_USE_SYNC)
		"FALSE" : TXOUTCLK1_USE_SYNC_BINARY <= 0;
		"TRUE" : TXOUTCLK1_USE_SYNC_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXOUTCLK1_USE_SYNC on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXOUTCLK1_USE_SYNC);
			$finish;
		end
	endcase

	case (RXRECCLK1_USE_SYNC)
		"FALSE" : RXRECCLK1_USE_SYNC_BINARY <= 0;
		"TRUE" : RXRECCLK1_USE_SYNC_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXRECCLK1_USE_SYNC on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXRECCLK1_USE_SYNC);
			$finish;
		end
	endcase

	case (RXPMACLKSEL)
		"REFCLK1" : RXPMACLKSEL_BINARY <= 2'b00;
		"REFCLK2" : RXPMACLKSEL_BINARY <= 2'b01;
		"GREFCLK" : RXPMACLKSEL_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXPMACLKSEL on GT11 instance %m is set to %s.  Legal values for this attribute are REFCLK1, REFCLK2 or GREFCLK.", RXPMACLKSEL);
			$finish;
		end
	endcase

	case (TXABPMACLKSEL)
		"REFCLK1" : TXABPMACLKSEL_BINARY <= 2'b00;
		"REFCLK2" : TXABPMACLKSEL_BINARY <= 2'b01;
		"GREFCLK" : TXABPMACLKSEL_BINARY <= 2'b10;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXABPMACLKSEL on GT11 instance %m is set to %s.  Legal values for this attribute are REFCLK1, REFCLK2 or GREFCLK.", TXABPMACLKSEL);
			$finish;
		end
	endcase

	case (BANDGAPSEL)
		"FALSE" : BANDGAPSEL_BINARY <= 0;
		"TRUE" : BANDGAPSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BANDGAPSEL on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BANDGAPSEL);
			$finish;
		end
	endcase

	case (BIASRESSEL)
		"FALSE" : BIASRESSEL_BINARY <= 0;
		"TRUE" : BIASRESSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BIASRESSEL on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BIASRESSEL);
			$finish;
		end
	endcase

	case (TXPHASESEL)
		"FALSE" : TXPHASESEL_BINARY <= 0;
		"TRUE" : TXPHASESEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPHASESEL on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXPHASESEL);
			$finish;
		end
	endcase

	case (PMACLKENABLE)
		"FALSE" : PMACLKENABLE_BINARY <= 0;
		"TRUE" : PMACLKENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMACLKENABLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMACLKENABLE);
			$finish;
		end
	endcase

	case (PMACOREPWRENABLE)
		"FALSE" : PMACOREPWRENABLE_BINARY <= 0;
		"TRUE" : PMACOREPWRENABLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMACOREPWRENABLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMACOREPWRENABLE);
			$finish;
		end
	endcase

	case (PMA_BIT_SLIP)
		"FALSE" : PMA_BIT_SLIP_BINARY <= 0;
		"TRUE" : PMA_BIT_SLIP_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMA_BIT_SLIP on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMA_BIT_SLIP);
			$finish;
		end
	endcase

	case (RXLB)
		"FALSE" : RXLB_BINARY <= 0;
		"TRUE" : RXLB_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXLB on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXLB);
			$finish;
		end
	endcase

	case (RXDCCOUPLE)
		"FALSE" : RXDCCOUPLE_BINARY <= 0;
		"TRUE" : RXDCCOUPLE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXDCCOUPLE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXDCCOUPLE);
			$finish;
		end
	endcase

	case (RXDIGRESET)
		"FALSE" : RXDIGRESET_BINARY <= 0;
		"TRUE" : RXDIGRESET_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXDIGRESET on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXDIGRESET);
			$finish;
		end
	endcase

	case (RXCPTST)
		"FALSE" : RXCPTST_BINARY <= 0;
		"TRUE" : RXCPTST_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCPTST on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCPTST);
			$finish;
		end
	endcase

	case (RXPDDTST)
		"FALSE" : RXPDDTST_BINARY <= 0;
		"TRUE" : RXPDDTST_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXPDDTST on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXPDDTST);
			$finish;
		end
	endcase

	case (RXACTST)
		"FALSE" : RXACTST_BINARY <= 0;
		"TRUE" : RXACTST_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXACTST on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXACTST);
			$finish;
		end
	endcase

	case (RXAFETST)
		"FALSE" : RXAFETST_BINARY <= 0;
		"TRUE" : RXAFETST_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXAFETST on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXAFETST);
			$finish;
		end
	endcase

	case (RXLKAPD)
		"FALSE" : RXLKAPD_BINARY <= 0;
		"TRUE" : RXLKAPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXLKAPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXLKAPD);
			$finish;
		end
	endcase

	case (RXRSDPD)
		"FALSE" : RXRSDPD_BINARY <= 0;
		"TRUE" : RXRSDPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXRSDPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXRSDPD);
			$finish;
		end
	endcase

	case (RXRCPPD)
		"FALSE" : RXRCPPD_BINARY <= 0;
		"TRUE" : RXRCPPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXRCPPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXRCPPD);
			$finish;
		end
	endcase

	case (RXRPDPD)
		"FALSE" : RXRPDPD_BINARY <= 0;
		"TRUE" : RXRPDPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXRPDPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXRPDPD);
			$finish;
		end
	endcase

	case (RXAFEPD)
		"FALSE" : RXAFEPD_BINARY <= 0;
		"TRUE" : RXAFEPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXAFEPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXAFEPD);
			$finish;
		end
	endcase

	case (RXPD)
		"FALSE" : RXPD_BINARY <= 0;
		"TRUE" : RXPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXPD);
			$finish;
		end
	endcase

	case (TXOUTDIV2SEL)
		1 : TXOUTDIV2SEL_BINARY <= 4'b0001;
		2 : TXOUTDIV2SEL_BINARY <= 4'b0010;
		4 : TXOUTDIV2SEL_BINARY <= 4'b0011;
		8 : TXOUTDIV2SEL_BINARY <= 4'b0100;
		16 : TXOUTDIV2SEL_BINARY <= 4'b0101;
		32 : TXOUTDIV2SEL_BINARY <= 4'b0110;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXOUTDIV2SEL on GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 4, 8, 16 or 32.", TXOUTDIV2SEL);
			$finish;
		end
	endcase

	case (TXPLLNDIVSEL)
		8 : TXPLLNDIVSEL_BINARY <= 4'b0000;
		10 : TXPLLNDIVSEL_BINARY <= 4'b0010;
		16 : TXPLLNDIVSEL_BINARY <= 4'b0100;
		20 : TXPLLNDIVSEL_BINARY <= 4'b0110;
		32 : TXPLLNDIVSEL_BINARY <= 4'b1000;
		40 : TXPLLNDIVSEL_BINARY <= 4'b1010;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPLLNDIVSEL on GT11 instance %m is set to %d.  Legal values for this attribute are 8, 10, 16, 20, 32 or 40.", TXPLLNDIVSEL);
			$finish;
		end
	endcase

	case (TXCPSEL)
		"FALSE" : TXCPSEL_BINARY <= 0;
		"TRUE" : TXCPSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXCPSEL on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXCPSEL);
			$finish;
		end
	endcase

	case (TXAPD)
		"FALSE" : TXAPD_BINARY <= 0;
		"TRUE" : TXAPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXAPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXAPD);
			$finish;
		end
	endcase

	case (TXLVLSHFTPD)
		"FALSE" : TXLVLSHFTPD_BINARY <= 0;
		"TRUE" : TXLVLSHFTPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXLVLSHFTPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXLVLSHFTPD);
			$finish;
		end
	endcase

	case (TXPRE_TAP_PD)
		"FALSE" : TXPRE_TAP_PD_BINARY <= 0;
		"TRUE" : TXPRE_TAP_PD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPRE_TAP_PD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXPRE_TAP_PD);
			$finish;
		end
	endcase

	case (TXDIGPD)
		"FALSE" : TXDIGPD_BINARY <= 0;
		"TRUE" : TXDIGPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXDIGPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXDIGPD);
			$finish;
		end
	endcase

	case (TXHIGHSIGNALEN)
		"FALSE" : TXHIGHSIGNALEN_BINARY <= 0;
		"TRUE" : TXHIGHSIGNALEN_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXHIGHSIGNALEN on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXHIGHSIGNALEN);
			$finish;
		end
	endcase

	case (TXAREFBIASSEL)
		"FALSE" : TXAREFBIASSEL_BINARY <= 0;
		"TRUE" : TXAREFBIASSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXAREFBIASSEL on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXAREFBIASSEL);
			$finish;
		end
	endcase

	case (TXSLEWRATE)
		"FALSE" : TXSLEWRATE_BINARY <= 0;
		"TRUE" : TXSLEWRATE_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXSLEWRATE on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXSLEWRATE);
			$finish;
		end
	endcase

	case (TXPOST_TAP_PD)
		"FALSE" : TXPOST_TAP_PD_BINARY <= 0;
		"TRUE" : TXPOST_TAP_PD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPOST_TAP_PD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXPOST_TAP_PD);
			$finish;
		end
	endcase

	case (TXPD)
		"FALSE" : TXPD_BINARY <= 0;
		"TRUE" : TXPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXPD);
			$finish;
		end
	endcase

	case (RXOUTDIV2SEL)
		1 : RXOUTDIV2SEL_BINARY <= 8'b00010001;
		2 : RXOUTDIV2SEL_BINARY <= 8'b00100010;
		4 : RXOUTDIV2SEL_BINARY <= 8'b00110011;
		8 : RXOUTDIV2SEL_BINARY <= 8'b01000100;
		16 : RXOUTDIV2SEL_BINARY <= 8'b01010101;
		32 : RXOUTDIV2SEL_BINARY <= 8'b01100110;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXOUTDIV2SEL on GT11 instance %m is set to %d.  Legal values for this attribute are 1, 2, 4, 8, 16 or 32.", RXOUTDIV2SEL);
			$finish;
		end
	endcase

	case (RXPLLNDIVSEL)
		8 : RXPLLNDIVSEL_BINARY <= 4'b0000;
		10 : RXPLLNDIVSEL_BINARY <= 4'b0010;
		16 : RXPLLNDIVSEL_BINARY <= 4'b0100;
		20 : RXPLLNDIVSEL_BINARY <= 4'b0110;
		32 : RXPLLNDIVSEL_BINARY <= 4'b1000;
		40 : RXPLLNDIVSEL_BINARY <= 4'b1010;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXPLLNDIVSEL on GT11 instance %m is set to %d.  Legal values for this attribute are 8, 10, 16, 20, 32 or 40.", RXPLLNDIVSEL);
			$finish;
		end
	endcase

	case (RXDIGRX)
		"FALSE" : RXDIGRX_BINARY <= 0;
		"TRUE" : RXDIGRX_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXDIGRX on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXDIGRX);
			$finish;
		end
	endcase

	case (RXCPSEL)
		"FALSE" : RXCPSEL_BINARY <= 0;
		"TRUE" : RXCPSEL_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXCPSEL on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXCPSEL);
			$finish;
		end
	endcase

	case (RXAPD)
		"FALSE" : RXAPD_BINARY <= 0;
		"TRUE" : RXAPD_BINARY <= 1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXAPD on GT11 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXAPD);
			$finish;
		end
	endcase

end

wire [63:0] synDigCfgChnBnd1;
wire [63:0] synDigCfgChnBnd2;
wire [63:0] synDigCfgClkCor1;
wire [63:0] synDigCfgClkCor2;
wire [63:0] synDigCfgMisc;
wire [63:0] synDigCfgComma1;
wire [63:0] synDigCfgComma2;
wire [63:0] synDigCfgSynPmaFD;
wire [63:0] synDigCfgCrc;
wire [63:0] PMACFG;
wire [63:0] PMACFG2;
wire [63:0] RXAFECFG;
wire [63:0] RXAEQCFG;
wire [63:0] TXCLCFG;
wire [63:0] TXACFG;
wire [63:0] RXACLCFG;

assign synDigCfgChnBnd1 = {
	1'b0, // RESERVED_CB1_BINARY,	// .synDigCfgChnBnd1 63 FALSE
	TX_BUFFER_USE_BINARY,	// .synDigCfgChnBnd1 62 TRUE
	RX_BUFFER_USE_BINARY,	// .synDigCfgChnBnd1 61 TRUE
	CHAN_BOND_SEQ_LEN_BINARY,	// .synDigCfgChnBnd1 60:58 1
	CHAN_BOND_SEQ_2_USE_BINARY,	// .synDigCfgChnBnd1 57 FALSE
	CHAN_BOND_ONE_SHOT_BINARY,	// .synDigCfgChnBnd1 56 FALSE
	CHAN_BOND_MODE_BINARY,	// .synDigCfgChnBnd1 55:54 OFF
	CHAN_BOND_LIMIT_BINARY,	// .synDigCfgChnBnd1 53:48 16
	CHAN_BOND_SEQ_1_MASK,	// .synDigCfgChnBnd1 47:44 4'b0000
	CHAN_BOND_SEQ_1_4,	// .synDigCfgChnBnd1 43:33 11'b00000000000
	CHAN_BOND_SEQ_1_3,	// .synDigCfgChnBnd1 32:22 11'b00000000000
	CHAN_BOND_SEQ_1_2,	// .synDigCfgChnBnd1 21:11 11'b00000000000
	CHAN_BOND_SEQ_1_1	// .synDigCfgChnBnd1 10:0 11'b00000000000
};

assign synDigCfgChnBnd2 = {
	8'b0, // CHAN_BOND_TUNE,	// .synDigCfgChnBnd2 63:56 8'b00000000
	1'b0, //UNUSED BINARY	// .synDigCfgChnBnd2 55 
	1'b0, //UNUSED_BINARY	// .synDigCfgChnBnd2 54
	CCCB_ARBITRATOR_DISABLE_BINARY,	// .synDigCfgChnBnd2 53 FALSE
	OPPOSITE_SELECT_BINARY,	// .synDigCfgChnBnd2 52 FALSE
	POWER_ENABLE_BINARY,	// .synDigCfgChnBnd2 51 TRUE
	3'b0, // TEST_MODE_BINARY,	// .synDigCfgChnBnd2 50:48 3'b000
	CHAN_BOND_SEQ_2_MASK,	// .synDigCfgChnBnd2 47:44 4'b0000
	CHAN_BOND_SEQ_2_4,	// .synDigCfgChnBnd2 43:33 11'b00000000000
	CHAN_BOND_SEQ_2_3,	// .synDigCfgChnBnd2 32:22 11'b00000000000
	CHAN_BOND_SEQ_2_2,	// .synDigCfgChnBnd2 21:11 11'b00000000000
	CHAN_BOND_SEQ_2_1	// .synDigCfgChnBnd2 10:0 11'b00000000000
};

assign synDigCfgClkCor1 = {
	RXDATA_SEL,	// .synDigCfgClkCor1 63:62 2'b00
	TXDATA_SEL,	// .synDigCfgClkCor1 61:60 2'b00
	1'b0, // RESERVED_CCB	// .synDigCfgClkCor1 59 1'b0
	CLK_COR_MIN_LAT_BINARY,	// .synDigCfgClkCor1 58:53 28
	1'b0, // RESERVED_CCA	// .synDigCfgClkCor1 52 1'b0
	PCS_BIT_SLIP_BINARY,	// .synDigCfgClkCor1 51 1'b0
	DIGRX_SYNC_MODE_BINARY, // .synDigCfgClkCor1 50 1'b0
	DIGRX_FWDCLK,	// .synDigCfgClkCor1 49:48 2'b0
	CLK_COR_SEQ_1_MASK,	// .synDigCfgClkCor1 47:44 4'b0000
	CLK_COR_SEQ_1_4,	// .synDigCfgClkCor1 43:33 11'b00000000000
	CLK_COR_SEQ_1_3,	// .synDigCfgClkCor1 32:22 11'b00000000000
	CLK_COR_SEQ_1_2,	// .synDigCfgClkCor1 21:11 11'b00000000000
	CLK_COR_SEQ_1_1	// .synDigCfgClkCor1 10:0 11'b00000000000
};

assign synDigCfgClkCor2 = {
	8'b0, // RX_LOS_THRESHOLD_BINARY,	// .synDigCfgClkCor2 63:56 4
	8'b0, // RX_LOS_INVALID_INCR_BINARY,	// .synDigCfgClkCor2 55:48 1
	CLK_COR_SEQ_2_MASK,	// .synDigCfgClkCor2 47:44 4'b0000
	CLK_COR_SEQ_2_4,	// .synDigCfgClkCor2 43:33 11'b00000000000
	CLK_COR_SEQ_2_3,	// .synDigCfgClkCor2 32:22 11'b00000000000
	CLK_COR_SEQ_2_2,	// .synDigCfgClkCor2 21:11 11'b00000000000
	CLK_COR_SEQ_2_1	// .synDigCfgClkCor2 10:0 11'b00000000000
};

assign synDigCfgMisc = {
	RXRECCLK1_USE_SYNC_BINARY,	// .synDigCfgMisc 63 FALSE
	TXOUTCLK1_USE_SYNC_BINARY,	// .synDigCfgMisc 62 FALSE
	TXCLK0_FORCE_PMACLK_BINARY,	// .synDigCfgMisc 61 1'b0
	RXCLK0_FORCE_PMACLK_BINARY,	// .synDigCfgMisc 60 1'b0
	TX_CLOCK_DIVIDER,	// .synDigCfgMisc 59:58 2'b00
	RX_CLOCK_DIVIDER,	// .synDigCfgMisc 57:56 2'b00
	TXCRCENABLE_BINARY,	// .synDigCfgMisc 55 FALSE
	TXCRCSAMECLOCK_BINARY,	// .synDigCfgMisc 54 FALSE
	TXCRCINVERTGEN_BINARY,	// .synDigCfgMisc 53 FALSE
	TXCRCCLOCKDOUBLE_BINARY,	// .synDigCfgMisc 52 FALSE
	RXCRCENABLE_BINARY,	// .synDigCfgMisc 51 FALSE
	RXCRCSAMECLOCK_BINARY,	// .synDigCfgMisc 50 FALSE
	RXCRCINVERTGEN_BINARY,	// .synDigCfgMisc 49 FALSE
	RXCRCCLOCKDOUBLE_BINARY,	// .synDigCfgMisc 48 FALSE
	RXFDCAL_CLOCK_DIVIDE_BINARY,	// .synDigCfgMisc 47:46 2'b00
	TXFDCAL_CLOCK_DIVIDE_BINARY,	// .synDigCfgMisc 45:44 2'b00
	RXBY_32_BINARY,	// .synDigCfgMisc 43 FALSE
	REPEATER_BINARY,	// .synDigCfgMisc 42 FALSE
	ENABLE_DCDR_BINARY,	// .synDigCfgMisc 41 FALSE
	SAMPLE_8X_BINARY,	// .synDigCfgMisc 40 FALSE
	DCDR_FILTER,	// .synDigCfgMisc 39:37 3'b110
	RXUSRDIVISOR_BINARY,	// .synDigCfgMisc 36:32 1
	SH_INVALID_CNT_MAX_BINARY,	// .synDigCfgMisc 31:24 16
	SH_CNT_MAX_BINARY,	// .synDigCfgMisc 23:16 64
	1'b0, // RESERVED_M2,	// .synDigCfgMisc 15 1'b0
	CLK_COR_8B10B_DE_BINARY,	// .synDigCfgMisc 14 FALSE
	CLK_CORRECT_USE_BINARY,	// .synDigCfgMisc 13 TRUE
	CLK_COR_SEQ_LEN_BINARY,	// .synDigCfgMisc 12:10 1
	CLK_COR_SEQ_DROP_BINARY,	// .synDigCfgMisc 9 FALSE
	CLK_COR_SEQ_2_USE_BINARY,	// .synDigCfgMisc 8 FALSE
	1'b0, // TXCLK0_INVERT_PMALEAF_BINARY,	// .synDigCfgMisc 7 FALSE
	1'b0, // RXCLK0_INVERT_PMALEAF_BINARY_BINARY,	// .synDigCfgMisc 6 FALSE
	CLK_COR_MAX_LAT_BINARY	// .synDigCfgMisc 5:0 36
};

assign synDigCfgComma1 = {
	22'h0, // RESERVED_CM2,	// .synDigCfgComma1 63:42 22'h000000
	COMMA_10B_MASK[9:0],	// .synDigCfgComma1 41:32 10'h007
	24'h0, // RESERVED_CM,	// .synDigCfgComma1 31:8 24'h000000
	COMMA32_BINARY,	// .synDigCfgComma1 7 FALSE
	PCOMMA_DETECT_BINARY,	// .synDigCfgComma1 6 TRUE
	MCOMMA_DETECT_BINARY,	// .synDigCfgComma1 5 TRUE
	DEC_VALID_COMMA_ONLY_BINARY,	// .synDigCfgComma1 4 TRUE
	DEC_PCOMMA_DETECT_BINARY,	// .synDigCfgComma1 3 TRUE
	DEC_MCOMMA_DETECT_BINARY,	// .synDigCfgComma1 2 TRUE
	ALIGN_COMMA_WORD_BINARY	// .synDigCfgComma1 1:0 1
};

assign synDigCfgComma2 = {
	PCOMMA_32B_VALUE,	// .synDigCfgComma2 63:32 PCOMMA_10B_VALUE = 32'Ha1a1a2a2/10'b17c
	MCOMMA_32B_VALUE	// .synDigCfgComma2 31:0 MCOMMA_10B_VALUE = 32'Ha1a1a2a2/10'b283
};

assign synDigCfgSynPmaFD = {
	1'b1, // AUTO_CAL_BINARY,	// .synDigCfgSynPmaFD 63 TRUE
	VCODAC_INIT,	// .synDigCfgSynPmaFD 62:53 10'b1010000000
	2'b00, // SLOWDOWN_CAL, //.synDigCfgSynPmaFD 52:51 2'b00
	1'b0, // BYPASS_FDET_BINARY,	// .synDigCfgSynPmaFD 50 FALSE
	LOOPCAL_WAIT,	// .synDigCfgSynPmaFD 49:48 2'b00
	1'b0, // BYPASS_CAL_BINARY,	// .synDigCfgSynPmaFD 47 FALSE
	FDET_HYS_CAL,	// .synDigCfgSynPmaFD 46:44 3'b000
	FDET_LCK_CAL,	// .synDigCfgSynPmaFD 43:41 3'b000
	FDET_HYS_SEL,	// .synDigCfgSynPmaFD 40:38 3'b000
	FDET_LCK_SEL,	// .synDigCfgSynPmaFD 37:35 3'b000
	VCO_CTRL_ENABLE_BINARY,	// .synDigCfgSynPmaFD 34 FALSE
	CYCLE_LIMIT_SEL,	// .synDigCfgSynPmaFD 33:32 2'b00
	1'b1, // RXAUTO_CAL_BINARY,	// .synDigCfgSynPmaFD 31 TRUE
	RXVCODAC_INIT,	// .synDigCfgSynPmaFD 30:21 10'b1010000000
	RXSLOWDOWN_CAL,	// .synDigCfgSynPmaFD 20:19 2'b00
	1'b0, // RXBYPASS_FDET_BINARY,	// .synDigCfgSynPmaFD 18 FALSE
	RXLOOPCAL_WAIT,	// .synDigCfgSynPmaFD 17:16 2'b00
	1'b0, // RXBYPASS_CAL_BINARY,	// .synDigCfgSynPmaFD 15 FALSE
	RXFDET_HYS_CAL,	// .synDigCfgSynPmaFD 14:12 3'b000
	RXFDET_LCK_CAL,	// .synDigCfgSynPmaFD 11:9 3'b000
	RXFDET_HYS_SEL,	// .synDigCfgSynPmaFD 8:6 3'b000
	RXFDET_LCK_SEL,	// .synDigCfgSynPmaFD 5:3 3'b000
	RXVCO_CTRL_ENABLE_BINARY,	// .synDigCfgSynPmaFD 2 FALSE
	RXCYCLE_LIMIT_SEL	// .synDigCfgSynPmaFD 1:0 2'b00
};

assign synDigCfgCrc = {
	TXCRCINITVAL,	// .synDigCfgCrc 63:32 32'h00000000
	RXCRCINITVAL	// .synDigCfgCrc 31:0 32'h00000000
};

assign PMACFG = {
	2'b0, // UNUSED_BINARY.PMACFG 63:62
	RXPMACLKSEL_BINARY,	// .PMACFG 61:60 2'b00
	RXPMACLKSEL_BINARY, // .PMACFG 59:58
	TXABPMACLKSEL_BINARY,	// .PMACFG 57:56 2'b00
	8'b0, // UNUSED_BINARY,	// .PMACFG 55:48
	1'b0, // PMATUNE_BINARY,	// .PMACFG 47 FALSE
	5'b0, // TXREGCTRL_BINARY,	// .PMACFG 46:42 5'b00000
	RXAREGCTRL,	// .PMACFG 41:37 5'b00000
	PMAVBGCTRL,	// .PMACFG 36:32 5'b00000
	BANDGAPSEL_BINARY,	// .PMACFG 31 FALSE
	PMAIREFTRIM,	// .PMACFG 30:27 4'b0000
	IREFBIASMODE,	// .PMACFG 26:25 2'b00
	BIASRESSEL_BINARY,	// .PMACFG 24 FALSE
	PMAVREFTRIM,	// .PMACFG 23:20 =4'b0000
	1'b0, // VREFSELECT_BINARY,	// .PMACFG 19 FALSE
	VREFBIASMODE,	// .PMACFG 18:17 2'b00
	1'b0, // PMABIASPD_BINARY,	// .PMACFG 16 FALSE
	2'b0, // UNUSED_BINARY,	// .PMACFG 15:14
	1'b0, // ATBENABLE_BINARY,	// .PMACFG 13 FALSE
	1'b0, // ATBBUMPEN_BINARY,	// .PMACFG 12 FALSE
	1'b0, // NATBENABLE_BINARY,	// .PMACFG 11 FALSE
	6'b0, // UNUSED_BINARY,	// .PMACFG 10:5
	TXPHASESEL_BINARY,	// .PMACFG 4 FALSE
	1'b0, // UNUSED_BINARY,	// .PMACFG 3 1'0
	1'b0, // PMACTRL_BINARY,	// .PMACFG 2 1'0
	PMACLKENABLE_BINARY,	// .PMACFG 1 TRUE
	PMACOREPWRENABLE_BINARY	// .PMACFG 0 TRUE
};

assign PMACFG2 = {
	46'b0, // UNUSED_BINARY,	// .PMACFG2 63:18
	18'b0 // ATBSEL_BINARY	// .PMACFG2 17:0 18'h00000
};

assign RXAFECFG = {
	RXMODE,	// .RXAFECFG 63:58 6'h00
	PMA_BIT_SLIP_BINARY, // 	// .RXAFECFG 57 FALSE
	RXASYNCDIVIDE, // 	// .RXAFECFG 56:55 2'b00
	RXCLKMODE,	// .RXAFECFG 54:49 6'b110000
	RXLB_BINARY,	// .RXAFECFG 48 FALSE
	RXFETUNE,	// .RXAFECFG 47:46 2'b01
	RXRCPADJ,	// .RXAFECFG 45:43 3'b000
	RXRIBADJ,	// .RXAFECFG 42:41 2'b00
	RXAFEEQ,	// .RXAFECFG 40:32 9'h000
	RXCMADJ,	// .RXAFECFG 31:30 2'b00
	RXCDRLOS,	// .RXAFECFG 29:24 6'b000000
	1'b0,	// UNUSED_BINARY, //.RXAFECFG 23 1'b0
	RXDCCOUPLE_BINARY,	// .RXAFECFG 22 FALSE
	1'b0, // UNUSED_BINARY,	// .RXAFECFG 21
	RXLKADJ,	// .RXAFECFG 20:16 5'b00000
	RXDIGRESET_BINARY,	// .RXAFECFG 15 FALSE
	RXFECONTROL2, // .RXAFECFG 14:12
	RXCPTST_BINARY,	// .RXAFECFG 11 FALSE
	RXPDDTST_BINARY,	// .RXAFECFG 10 FALSE
	RXACTST_BINARY,	// .RXAFECFG 9 FALSE
	RXAFETST_BINARY,	// .RXAFECFG 8 FALSE
	RXFECONTROL1,	// .RXAFECFG 7:6
	RXLKAPD_BINARY,	// .RXAFECFG 5 FALSE
	RXRSDPD_BINARY,	// .RXAFECFG 4 FALSE
	RXRCPPD_BINARY,	// .RXAFECFG 3 FALSE
	RXRPDPD_BINARY,	// .RXAFECFG 2 FALSE
	RXAFEPD_BINARY,	// .RXAFECFG 1 FALSE
	RXPD_BINARY	// .RXAFECFG 0 FALSE
};

assign RXAEQCFG = {
	RXEQ	// .RXAEQCFG 63:0 64'h0000000000000000
};

assign TXCLCFG = {
	TXOUTDIV2SEL_BINARY, // .TXCLCFG 63:60
	TXPLLNDIVSEL_BINARY,	// .TXCLCFG 59:56 4'b0000
	TXCLMODE,	// .TXCLCFG 55:54 2'b00
	TXLOOPFILT,	// .TXCLCFG 53:50 4'b0000
	1'b0, // UNUSED_BINARY,	// .TXCLCFG 49
	1'b0, // UNUSED_BINARY,	// .TXCLCFG 48
	TXTUNE[12:0], // .TXCLCFG 47:35
	1'b0, // UNUSED_BINARY,	// .TXCLCFG 34
	1'b0, // UNUSED_BINARY,	// .TXCLCFG 33
	TXCPSEL_BINARY,	// .TXCLCFG 32 FALSE
	1'b0, // TXDACTST_BINARY,	// .TXCLCFG 31 FALSE
	TXOUTDIV2SEL_BINARY,	// .TXCLCFG 30:27 4'b0000
	TXCTRL1[9:0], // UNUSED_BINARY,	// .TXCLCFG 26:17
	1'b0, // TXQPPD_BINARY,	// .TXCLCFG 16 FALSE
	1'b0, // TXCMFPD_BINARY,	// .TXCLCFG 15 FALSE
	1'b0, // TXVCOPD_BINARY,	// .TXCLCFG 14 FALSE
	1'b0, // TXADCADJPD_BINARY,	// .TXCLCFG 13 FALSE
	1'b0, // TXDIVPD_BINARY,	// .TXCLCFG 12 FALSE
	1'b0, // TXBIASPD_BINARY,	// .TXCLCFG 11 FALSE
	1'b0, // TXVCOBUFPD_BINARY,	// .TXCLCFG 10 FALSE
	1'b0, // TXDIVBUFPD_BINARY,	// .TXCLCFG 9 FALSE
	TXAPD_BINARY,	// .TXCLCFG 8 FALSE
	1'b0, // TXAPTST_BINARY,	// .TXCLCFG 7 FALSE
	1'b0, // TXCMFTST_BINARY,	// .TXCLCFG 6 FALSE
	1'b0, // TXFILTTST_BINARY,	// .TXCLCFG 5 FALSE
	1'b0, // TXDIVTST_BINARY,	// .TXCLCFG 4 FALSE
	1'b0, // TXPFDTST_BINARY,	// .TXCLCFG 3 FALSE
	1'b0, // TXVCOBUFTST_BINARY,	// .TXCLCFG 2 FALSE
	1'b0, // TXDIVBUFTST_BINARY,	// .TXCLCFG 1 FALSE
	1'b0 // TXVCOTST_BINARY	// .TXCLCFG 0 FALSE
};

assign TXACFG = {
	4'b0, // TXLNDR_TST1_BINARY,	// .TXACFG 63:60 4'b0000
	TXLVLSHFTPD_BINARY,	// .TXACFG 59 FALSE
	TXPRE_PRDRV_DAC,	// .TXACFG 58:56 3'b000
	TXPRE_TAP_PD_BINARY,	// .TXACFG 55 FALSE
	TXPRE_TAP_DAC[4:3],	// .TXACFG 54:53 5'b00000
	TXDIGPD_BINARY,	// .TXACFG 52 FALSE
	TXCLKMODE,	// .TXACFG 51:48 4'b1100
	TXPRE_TAP_DAC[2:0],	// .TXACFG 47:45 5'b00000
	1'b0, // TXCFGENABLE_BINARY,	// .TXACFG 44 FALSE
	TXHIGHSIGNALEN_BINARY,	// .TXACFG 43 TRUE
	TXAREFBIASSEL_BINARY,	// .TXACFG 42 FALSE
	TXTERMTRIM,	// .TXACFG 41:38 4'b0000
	TXASYNCDIVIDE[1], // 	.TXACFG 37 FALSE
	TXSLEWRATE_BINARY,	// .TXACFG 36 FALSE
	TXPOST_PRDRV_DAC,	// .TXACFG 35:33 3'b000
	TXDAT_PRDRV_DAC,	// .TXACFG 32:30 3'b000
	TXASYNCDIVIDE[0], // 	.TXACFG 29 
	TXPOST_TAP_PD_BINARY,	// .TXACFG 28 TRUE
	TXPOST_TAP_DAC,	// .TXACFG 27:23 5'b00000
	2'b0, // TXLNDR_TST2_BINARY,	// .TXACFG 22:21 2'b00
	TXDAT_TAP_DAC,	// .TXACFG 20:16 5'b00000
	15'b0, // UNUSED_BINARY,	// .TXACFG 15:1
	TXPD_BINARY	// .TXACFG 0 FALSE
};

assign RXACLCFG = {
	RXOUTDIV2SEL_BINARY[7:4],	// .RXACLCFG 63:60 4'b0000
	RXPLLNDIVSEL_BINARY,	// .RXACLCFG 59:56 4'b0000
	RXCLMODE,	// .RXACLCFG 55:54 2'b00
	RXLOOPFILT,	// .RXACLCFG 53:50 4'b0000
	RXDIGRX_BINARY,	// .RXACLCFG 49 FALSE
	1'b0, // UNUSED_BINARY,	// .RXACLCFG 48 FALSE
	RXTUNE[12:0], // .RXACLCFG 47:35
	1'b0, // UNUSED_BINARY,	// .RXACLCFG 34 FALSE
	1'b0, // UNUSED_BINARY,	// .RXACLCFG 33 FALSE
	RXCPSEL_BINARY,	// .RXACLCFG 32 FALSE
	1'b0, // RXDACTST_BINARY,	// .RXACLCFG 31 FALSE
	RXOUTDIV2SEL_BINARY[3:0], // .RXACLCFG 30:27
	RXCTRL1[9:0], // .RXACLCFG 26:17
	1'b0, // RXQPPD_BINARY,	// .RXACLCFG 16 FALSE
	1'b1, // RXCMFPD_BINARY,	// .RXACLCFG 15 TRUE
	1'b0, // RXVCOPD_BINARY,	// .RXACLCFG 14 FALSE
	1'b0, // RXADCADJPD_BINARY,	// .RXACLCFG 13 FALSE
	1'b0, // RXDIVPD_BINARY,	// .RXACLCFG 12 FALSE
	1'b0, // RXBIASPD_BINARY,	// .RXACLCFG 11 FALSE
	1'b0, // RXVCOBUFPD_BINARY,	// .RXACLCFG 10 FALSE
	1'b0, // RXDIVBUFPD_BINARY,	// .RXACLCFG 9 FALSE
	RXAPD_BINARY,	// .RXACLCFG 8 FALSE
	1'b0, // RXAPTST_BINARY,	// .RXACLCFG 7 FALSE
	1'b0, // RXCMFTST_BINARY,	// .RXACLCFG 6 FALSE
	1'b0, // RXFILTTST_BINARY,	// .RXACLCFG 5 FALSE
	1'b0, // RXDIVTST_BINARY,	// .RXACLCFG 4 FALSE
	1'b0, // RXPFDTST_BINARY,	// .RXACLCFG 3 FALSE
	1'b0, // RXVCOBUFTST_BINARY,	// .RXACLCFG 2 FALSE
	1'b0, // RXDIVBUFTST_BINARY,	// .RXACLCFG 1 FALSE
	1'b0 // RXVCOTST_BINARY	// .RXACLCFG 0 FALSE
};


GT11_SWIFT gt11_swift_1 (
	.GSR (GSR),

	.GT11_MODE(GT11_MODE_BINARY),

	.synDigCfgChnBnd1 (synDigCfgChnBnd1),
	.synDigCfgChnBnd2 (synDigCfgChnBnd2),
	.synDigCfgClkCor1 (synDigCfgClkCor1),
	.synDigCfgClkCor2 (synDigCfgClkCor2),
	.synDigCfgMisc (synDigCfgMisc),
	.synDigCfgComma1 (synDigCfgComma1),
	.synDigCfgComma2 (synDigCfgComma2),
	.synDigCfgSynPmaFD (synDigCfgSynPmaFD),
	.synDigCfgCrc (synDigCfgCrc),
	.PMACFG (PMACFG),
	.PMACFG2 (PMACFG2),
	.RXAFECFG (RXAFECFG),
	.RXAEQCFG (RXAEQCFG),
	.TXCLCFG (TXCLCFG),
	.TXACFG (TXACFG),
	.RXACLCFG (RXACLCFG), 

	.CHBONDO(CHBONDO),
	.COMBUSOUT(COMBUSOUT),
	.DO(DO),
	.DRDY(DRDY),
	.RXBUFERR(RXBUFERR),
	.RXCALFAIL(RXCALFAIL),
	.RXCHARISCOMMA(RXCHARISCOMMA),
	.RXCHARISK(RXCHARISK),
	.RXCOMMADET(RXCOMMADET),
	.RXCRCOUT(RXCRCOUT),
	.RXCYCLELIMIT(RXCYCLELIMIT),
	.RXDATA(RXDATA),
	.RXDISPERR(RXDISPERR),
	.RXLOCK(RXLOCK),
	.RXLOSSOFSYNC(RXLOSSOFSYNC),
	.RXMCLK(RXMCLK),
	.RXNOTINTABLE(RXNOTINTABLE),
	.RXPCSHCLKOUT(RXPCSHCLKOUT),
	.RXREALIGN(RXREALIGN),
	.RXRECCLK1(RXRECCLK1),
	.RXRECCLK2(RXRECCLK2),
	.RXRUNDISP(RXRUNDISP),
	.RXSIGDET(RXSIGDET),
	.RXSTATUS(RXSTATUS),
	.TX1N(TX1N),
	.TX1P(TX1P),
	.TXBUFERR(TXBUFERR),
	.TXCALFAIL(TXCALFAIL),
	.TXCRCOUT(TXCRCOUT),
	.TXCYCLELIMIT(TXCYCLELIMIT),
	.TXKERR(TXKERR),
	.TXLOCK(TXLOCK),
	.TXOUTCLK1(TXOUTCLK1),
	.TXOUTCLK2(TXOUTCLK2),
	.TXPCSHCLKOUT(TXPCSHCLKOUT),
	.TXRUNDISP(TXRUNDISP),
	.CHBONDI(CHBONDI),
	.COMBUSIN(COMBUSIN),
	.DADDR(DADDR),
	.DCLK(DCLK),
	.DEN(DEN),
	.DI(DI),
	.DWE(DWE),
	.ENCHANSYNC(ENCHANSYNC),
	.ENMCOMMAALIGN(ENMCOMMAALIGN),
	.ENPCOMMAALIGN(ENPCOMMAALIGN),
	.GREFCLK(GREFCLK),
	.LOOPBACK(LOOPBACK),
	.POWERDOWN(POWERDOWN),
	.REFCLK1(REFCLK1),
	.REFCLK2(REFCLK2),
	.RX1N(RX1N),
	.RX1P(RX1P),
	.RXBLOCKSYNC64B66BUSE(RXBLOCKSYNC64B66BUSE),
	.RXCLKSTABLE(RXCLKSTABLE),
	.RXCOMMADETUSE(RXCOMMADETUSE),
	.RXCRCCLK(RXCRCCLK),
	.RXCRCDATAVALID(RXCRCDATAVALID),
	.RXCRCDATAWIDTH(RXCRCDATAWIDTH),
	.RXCRCIN(RXCRCIN),
	.RXCRCINIT(RXCRCINIT),
	.RXCRCINTCLK(RXCRCINTCLK),
	.RXCRCPD(RXCRCPD),
	.RXCRCRESET(RXCRCRESET),
	.RXDATAWIDTH(RXDATAWIDTH),
	.RXDEC64B66BUSE(RXDEC64B66BUSE),
	.RXDEC8B10BUSE(RXDEC8B10BUSE),
	.RXDESCRAM64B66BUSE(RXDESCRAM64B66BUSE),
	.RXIGNOREBTF(RXIGNOREBTF),
	.RXINTDATAWIDTH(RXINTDATAWIDTH),
	.RXPMARESET(RXPMARESET),
	.RXPOLARITY(RXPOLARITY),
	.RXRESET(RXRESET),
	.RXSLIDE(RXSLIDE),
	.RXSYNC(RXSYNC),
	.RXUSRCLK(RXUSRCLK),
	.RXUSRCLK2(RXUSRCLK2),
	.TXBYPASS8B10B(TXBYPASS8B10B),
	.TXCHARDISPMODE(TXCHARDISPMODE),
	.TXCHARDISPVAL(TXCHARDISPVAL),
	.TXCHARISK(TXCHARISK),
	.TXCLKSTABLE(TXCLKSTABLE),
	.TXCRCCLK(TXCRCCLK),
	.TXCRCDATAVALID(TXCRCDATAVALID),
	.TXCRCDATAWIDTH(TXCRCDATAWIDTH),
	.TXCRCIN(TXCRCIN),
	.TXCRCINIT(TXCRCINIT),
	.TXCRCINTCLK(TXCRCINTCLK),
	.TXCRCPD(TXCRCPD),
	.TXCRCRESET(TXCRCRESET),
	.TXDATA(TXDATA),
	.TXDATAWIDTH(TXDATAWIDTH),
	.TXENC64B66BUSE(TXENC64B66BUSE),
	.TXENC8B10BUSE(TXENC8B10BUSE),
	.TXENOOB(TXENOOB),
	.TXGEARBOX64B66BUSE(TXGEARBOX64B66BUSE),
	.TXINHIBIT(TXINHIBIT),
	.TXINTDATAWIDTH(TXINTDATAWIDTH),
	.TXPMARESET(TXPMARESET),
	.TXPOLARITY(TXPOLARITY),
	.TXRESET(TXRESET),
	.TXSCRAM64B66BUSE(TXSCRAM64B66BUSE),
	.TXSYNC(TXSYNC),
	.TXUSRCLK(TXUSRCLK),
	.TXUSRCLK2(TXUSRCLK2)
);

specify
	(DCLK => DO) = (100, 100);
	(DCLK => DRDY) = (100, 100);
	(RXCRCINTCLK => RXCRCOUT) = (100, 100);
	(RXUSRCLK => CHBONDO) = (100, 100);
	(RXUSRCLK2 => RXBUFERR) = (100, 100);
	(RXUSRCLK2 => RXCHARISCOMMA) = (100, 100);
	(RXUSRCLK2 => RXCHARISK) = (100, 100);
	(RXUSRCLK2 => RXCOMMADET) = (100, 100);
	(RXUSRCLK2 => RXCYCLELIMIT) = (100, 100);
	(RXUSRCLK2 => RXDATA) = (100, 100);
	(RXUSRCLK2 => RXDISPERR) = (100, 100);
	(RXUSRCLK2 => RXLOCK) = (100, 100);
	(RXUSRCLK2 => RXLOSSOFSYNC) = (100, 100);
	(RXUSRCLK2 => RXNOTINTABLE) = (100, 100);
	(RXUSRCLK2 => RXREALIGN) = (100, 100);
	(RXUSRCLK2 => RXRUNDISP) = (100, 100);
	(RXUSRCLK2 => RXSIGDET) = (100, 100);
	(RXUSRCLK2 => RXSTATUS) = (100, 100);
	(TXCRCINTCLK => TXCRCOUT) = (100, 100);
	(TXUSRCLK2 => RXCALFAIL) = (100, 100);
	(TXUSRCLK2 => TXBUFERR) = (100, 100);
	(TXUSRCLK2 => TXCALFAIL) = (100, 100);
	(TXUSRCLK2 => TXCYCLELIMIT) = (100, 100);
	(TXUSRCLK2 => TXKERR) = (100, 100);
	(TXUSRCLK2 => TXLOCK) = (100, 100);
	(TXUSRCLK2 => TXRUNDISP) = (100, 100);
	specparam PATHPULSE$ = 0;
endspecify
endmodule
